/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.interfaces;

import java.util.Comparator;
import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.functional.failable.FailableBinaryOperator;
import net.digitalid.utility.functional.interfaces.BinaryFunction;
import net.digitalid.utility.functional.interfaces.UnaryOperator;
import net.digitalid.utility.validation.annotations.type.Functional;
import net.digitalid.utility.validation.annotations.type.Immutable;

@Immutable
@Functional
public interface BinaryOperator<@Specifiable TYPE>
extends BinaryFunction<TYPE, TYPE, TYPE>,
FailableBinaryOperator<TYPE, RuntimeException> {
    @Pure
    default public BinaryOperator<TYPE> before(UnaryOperator<TYPE> operator) {
        return (input0, input1) -> operator.evaluate(this.evaluate(input0, input1));
    }

    @Pure
    default public BinaryOperator<TYPE> after(UnaryOperator<TYPE> operator0, UnaryOperator<TYPE> operator1) {
        return (input0, input1) -> this.evaluate(operator0.evaluate(input0), operator1.evaluate(input1));
    }

    @Pure
    default public BinaryOperator<TYPE> replaceNull(@Captured TYPE defaultValue) {
        return (input0, input1) -> input0 != null && input1 != null ? this.evaluate(input0, input1) : defaultValue;
    }

    @Override
    @Pure
    default public BinaryOperator<TYPE> propagateNull() {
        return this.replaceNull((Object)null);
    }

    @Pure
    public static <TYPE> BinaryOperator<TYPE> constant(@Captured TYPE output) {
        return (input0, input1) -> output;
    }

    @Pure
    public static <TYPE> BinaryOperator<TYPE> min(Comparator<? super TYPE> comparator) {
        return (input0, input1) -> comparator.compare((Object)input0, (Object)input1) <= 0 ? input0 : input1;
    }

    @Pure
    public static <TYPE> BinaryOperator<TYPE> max(Comparator<? super TYPE> comparator) {
        return (input0, input1) -> comparator.compare((Object)input0, (Object)input1) >= 0 ? input0 : input1;
    }
}

