/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.failable;

import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.generics.Unspecifiable;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.functional.failable.FailableUnaryFunction;
import net.digitalid.utility.functional.interfaces.Consumer;
import net.digitalid.utility.functional.interfaces.UnaryOperator;
import net.digitalid.utility.validation.annotations.type.Functional;
import net.digitalid.utility.validation.annotations.type.Immutable;

@Immutable
@Functional
public interface FailableUnaryOperator<@Specifiable TYPE, @Unspecifiable EXCEPTION extends Exception>
extends FailableUnaryFunction<TYPE, TYPE, EXCEPTION> {
    @Pure
    default public UnaryOperator<TYPE> suppressExceptions(@Captured Consumer<? super Exception> handler, @Captured TYPE defaultOutput) {
        return input -> {
            try {
                return this.evaluate(input);
            }
            catch (Exception exception) {
                handler.consume(exception);
                return defaultOutput;
            }
        };
    }

    @Pure
    default public UnaryOperator<TYPE> suppressExceptions(@Captured Consumer<? super Exception> handler) {
        return this.suppressExceptions((Consumer)handler, (Object)null);
    }

    @Pure
    default public UnaryOperator<TYPE> suppressExceptions(@Captured TYPE defaultOutput) {
        return this.suppressExceptions(Consumer.DO_NOTHING, (Object)defaultOutput);
    }

    @Pure
    default public UnaryOperator<TYPE> suppressExceptions() {
        return this.suppressExceptions(Consumer.DO_NOTHING, (Object)null);
    }

    @Pure
    public static <TYPE, EXCEPTION extends Exception> FailableUnaryOperator<TYPE, EXCEPTION> compose(FailableUnaryOperator<TYPE, ? extends EXCEPTION> operator0, FailableUnaryOperator<TYPE, ? extends EXCEPTION> operator1) {
        return input -> operator1.evaluate(operator0.evaluate(input));
    }

    @Pure
    default public FailableUnaryOperator<TYPE, EXCEPTION> before(FailableUnaryOperator<TYPE, ? extends EXCEPTION> operator) {
        return input -> operator.evaluate(this.evaluate(input));
    }

    @Pure
    default public FailableUnaryOperator<TYPE, EXCEPTION> after(FailableUnaryOperator<TYPE, ? extends EXCEPTION> operator) {
        return input -> this.evaluate(operator.evaluate(input));
    }

    @Pure
    default public FailableUnaryOperator<TYPE, EXCEPTION> replaceNull(@Captured TYPE defaultOutput) {
        return input -> input != null ? this.evaluate(input) : defaultOutput;
    }

    @Pure
    default public FailableUnaryOperator<TYPE, EXCEPTION> propagateNull() {
        return this.replaceNull((Object)null);
    }
}

