/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.failable;

import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.generics.Unspecifiable;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.annotations.ownership.NonCaptured;
import net.digitalid.utility.annotations.parameter.Unmodified;
import net.digitalid.utility.functional.interfaces.Consumer;
import net.digitalid.utility.functional.interfaces.UnaryFunction;
import net.digitalid.utility.validation.annotations.type.Functional;
import net.digitalid.utility.validation.annotations.type.Immutable;

@Immutable
@Functional
public interface FailableUnaryFunction<@Specifiable INPUT, @Specifiable OUTPUT, @Unspecifiable EXCEPTION extends Exception> {
    @Pure
    public OUTPUT evaluate(@NonCaptured @Unmodified INPUT var1) throws EXCEPTION;

    @Pure
    default public UnaryFunction<INPUT, OUTPUT> suppressExceptions(@Captured Consumer<? super Exception> handler, @Captured OUTPUT defaultOutput) {
        return input -> {
            try {
                return this.evaluate(input);
            }
            catch (Exception exception) {
                handler.consume(exception);
                return defaultOutput;
            }
        };
    }

    @Pure
    default public UnaryFunction<INPUT, OUTPUT> suppressExceptions(@Captured Consumer<? super Exception> handler) {
        return this.suppressExceptions(handler, null);
    }

    @Pure
    default public UnaryFunction<INPUT, OUTPUT> suppressExceptions(@Captured OUTPUT defaultOutput) {
        return this.suppressExceptions(Consumer.DO_NOTHING, defaultOutput);
    }

    @Pure
    default public UnaryFunction<INPUT, OUTPUT> suppressExceptions() {
        return this.suppressExceptions(Consumer.DO_NOTHING, null);
    }

    @Pure
    public static <INPUT, INTERMEDIATE, OUTPUT, EXCEPTION extends Exception> FailableUnaryFunction<INPUT, OUTPUT, EXCEPTION> compose(FailableUnaryFunction<? super INPUT, ? extends INTERMEDIATE, ? extends EXCEPTION> function0, FailableUnaryFunction<? super INTERMEDIATE, ? extends OUTPUT, ? extends EXCEPTION> function1) {
        return input -> function1.evaluate((Object)function0.evaluate(input));
    }

    @Pure
    default public <FINAL_OUTPUT> FailableUnaryFunction<INPUT, FINAL_OUTPUT, EXCEPTION> before(FailableUnaryFunction<? super OUTPUT, ? extends FINAL_OUTPUT, ? extends EXCEPTION> function) {
        return input -> function.evaluate((OUTPUT)this.evaluate(input));
    }

    @Pure
    default public <INITIAL_INPUT> FailableUnaryFunction<INITIAL_INPUT, OUTPUT, EXCEPTION> after(FailableUnaryFunction<? super INITIAL_INPUT, ? extends INPUT, ? extends EXCEPTION> function) {
        return input -> this.evaluate(function.evaluate((Object)input));
    }

    @Pure
    default public FailableUnaryFunction<INPUT, OUTPUT, EXCEPTION> replaceNull(@Captured OUTPUT defaultOutput) {
        return input -> input != null ? this.evaluate(input) : defaultOutput;
    }

    @Pure
    default public FailableUnaryFunction<INPUT, OUTPUT, EXCEPTION> propagateNull() {
        return this.replaceNull(null);
    }
}

