/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.failable;

import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.generics.Unspecifiable;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.functional.failable.FailableUnaryFunction;
import net.digitalid.utility.functional.interfaces.Consumer;
import net.digitalid.utility.functional.interfaces.Producer;
import net.digitalid.utility.validation.annotations.type.Functional;
import net.digitalid.utility.validation.annotations.type.Mutable;

@Mutable
@Functional
public interface FailableProducer<@Specifiable OUTPUT, @Unspecifiable EXCEPTION extends Exception> {
    @Impure
    @Capturable
    public OUTPUT produce() throws EXCEPTION;

    @Pure
    default public Producer<OUTPUT> suppressExceptions(@Captured Consumer<? super Exception> handler, @Captured OUTPUT defaultOutput) {
        return () -> {
            try {
                return this.produce();
            }
            catch (Exception exception) {
                handler.consume(exception);
                return defaultOutput;
            }
        };
    }

    @Pure
    default public Producer<OUTPUT> suppressExceptions(@Captured Consumer<? super Exception> handler) {
        return this.suppressExceptions(handler, null);
    }

    @Pure
    default public Producer<OUTPUT> suppressExceptions(@Captured OUTPUT defaultOutput) {
        return this.suppressExceptions(Consumer.DO_NOTHING, defaultOutput);
    }

    @Pure
    default public Producer<OUTPUT> suppressExceptions() {
        return this.suppressExceptions(Consumer.DO_NOTHING, null);
    }

    @Pure
    @Capturable
    public static <INTERMEDIATE, OUTPUT, EXCEPTION extends Exception> FailableProducer<OUTPUT, EXCEPTION> compose(@Captured FailableProducer<? extends INTERMEDIATE, ? extends EXCEPTION> producer, FailableUnaryFunction<? super INTERMEDIATE, ? extends OUTPUT, ? extends EXCEPTION> function) {
        return () -> function.evaluate((Object)producer.produce());
    }

    @Pure
    default public <FINAL_OUTPUT> FailableProducer<FINAL_OUTPUT, EXCEPTION> before(FailableUnaryFunction<? super OUTPUT, ? extends FINAL_OUTPUT, ? extends EXCEPTION> function) {
        return () -> function.evaluate((OUTPUT)this.produce());
    }

    @Pure
    default public FailableUnaryFunction<Object, OUTPUT, EXCEPTION> asFunction() {
        return input -> this.produce();
    }

    @Pure
    default public FailableProducer<OUTPUT, EXCEPTION> synchronize() {
        return () -> {
            FailableProducer failableProducer = this;
            synchronized (failableProducer) {
                return this.produce();
            }
        };
    }

    @Pure
    default public FailableProducer<OUTPUT, EXCEPTION> memoize(final long duration) {
        return new FailableProducer<OUTPUT, EXCEPTION>(){
            private OUTPUT cachedOutput = null;
            private long lastProduction = 0L;

            @Override
            @Impure
            public OUTPUT produce() throws Exception {
                long currentTime = System.currentTimeMillis();
                if (this.lastProduction == 0L || this.lastProduction + duration < currentTime) {
                    this.cachedOutput = FailableProducer.this.produce();
                    this.lastProduction = currentTime;
                }
                return this.cachedOutput;
            }
        };
    }
}

