/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.failable;

import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.generics.Unspecifiable;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.annotations.ownership.NonCaptured;
import net.digitalid.utility.annotations.parameter.Unmodified;
import net.digitalid.utility.functional.failable.FailableUnaryFunction;
import net.digitalid.utility.functional.interfaces.Consumer;
import net.digitalid.utility.functional.interfaces.Predicate;
import net.digitalid.utility.functional.iterables.FiniteIterable;
import net.digitalid.utility.validation.annotations.type.Functional;
import net.digitalid.utility.validation.annotations.type.Immutable;

@Immutable
@Functional
public interface FailablePredicate<@Specifiable INPUT, @Unspecifiable EXCEPTION extends Exception> {
    @Pure
    public boolean evaluate(@NonCaptured @Unmodified INPUT var1) throws EXCEPTION;

    @Pure
    default public Predicate<INPUT> suppressExceptions(@Captured Consumer<? super Exception> handler, boolean defaultOutput) {
        return input -> {
            try {
                return this.evaluate(input);
            }
            catch (Exception exception) {
                handler.consume(exception);
                return defaultOutput;
            }
        };
    }

    @Pure
    default public Predicate<INPUT> suppressExceptions(@Captured Consumer<? super Exception> handler) {
        return this.suppressExceptions(handler, false);
    }

    @Pure
    default public Predicate<INPUT> suppressExceptions(boolean defaultOutput) {
        return this.suppressExceptions(Consumer.DO_NOTHING, defaultOutput);
    }

    @Pure
    default public Predicate<INPUT> suppressExceptions() {
        return this.suppressExceptions(Consumer.DO_NOTHING, false);
    }

    @Pure
    default public FailablePredicate<INPUT, EXCEPTION> and(FailablePredicate<? super INPUT, ? extends EXCEPTION> predicate) {
        return input -> this.evaluate(input) && predicate.evaluate(input);
    }

    @Pure
    public static <INPUT, EXCEPTION extends Exception> FailablePredicate<INPUT, EXCEPTION> and(FiniteIterable<? extends FailablePredicate<? super INPUT, ? extends EXCEPTION>> predicates) {
        return input -> {
            for (FailablePredicate predicate : predicates) {
                if (predicate.evaluate(input)) continue;
                return false;
            }
            return true;
        };
    }

    @Pure
    default public FailablePredicate<INPUT, EXCEPTION> or(FailablePredicate<? super INPUT, ? extends EXCEPTION> predicate) {
        return input -> this.evaluate(input) || predicate.evaluate(input);
    }

    @Pure
    @SafeVarargs
    public static <INPUT, EXCEPTION extends Exception> FailablePredicate<INPUT, EXCEPTION> or(FailablePredicate<? super INPUT, ? extends EXCEPTION> ... predicates) {
        return input -> {
            for (FailablePredicate predicate : predicates) {
                if (!predicate.evaluate(input)) continue;
                return true;
            }
            return false;
        };
    }

    @Pure
    public static <INPUT, EXCEPTION extends Exception> FailablePredicate<INPUT, EXCEPTION> or(FiniteIterable<? extends FailablePredicate<? super INPUT, ? extends EXCEPTION>> predicates) {
        return input -> {
            for (FailablePredicate predicate : predicates) {
                if (!predicate.evaluate(input)) continue;
                return true;
            }
            return false;
        };
    }

    @Pure
    default public FailablePredicate<INPUT, EXCEPTION> negate() {
        return input -> !this.evaluate(input);
    }

    @Pure
    public static <INPUT, INTERMEDIATE, EXCEPTION extends Exception> FailablePredicate<INPUT, EXCEPTION> compose(FailableUnaryFunction<? super INPUT, ? extends INTERMEDIATE, ? extends EXCEPTION> function, FailablePredicate<? super INTERMEDIATE, ? extends EXCEPTION> predicate) {
        return input -> predicate.evaluate((Object)function.evaluate(input));
    }

    @Pure
    default public <INITIAL_INPUT> FailablePredicate<INITIAL_INPUT, EXCEPTION> after(FailableUnaryFunction<? super INITIAL_INPUT, ? extends INPUT, ? extends EXCEPTION> function) {
        return input -> this.evaluate(function.evaluate((Object)input));
    }

    @Pure
    default public FailableUnaryFunction<INPUT, Boolean, EXCEPTION> asFunction() {
        return this::evaluate;
    }

    @Pure
    default public FailablePredicate<INPUT, EXCEPTION> replaceNull(boolean defaultValue) {
        return input -> input != null ? this.evaluate(input) : defaultValue;
    }
}

