/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.failable;

import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.generics.Unspecifiable;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.functional.failable.FailableUnaryFunction;
import net.digitalid.utility.functional.interfaces.Consumer;
import net.digitalid.utility.validation.annotations.type.Functional;
import net.digitalid.utility.validation.annotations.type.Mutable;

@Mutable
@Functional
public interface FailableConsumer<@Specifiable INPUT, @Unspecifiable EXCEPTION extends Exception> {
    @Impure
    public void consume(@Captured INPUT var1) throws EXCEPTION;

    @Pure
    @Capturable
    default public Consumer<INPUT> suppressExceptions(@Captured Consumer<? super Exception> handler) {
        return input -> {
            try {
                this.consume(input);
            }
            catch (Exception exception) {
                handler.consume(exception);
            }
        };
    }

    @Pure
    @Capturable
    default public Consumer<INPUT> suppressExceptions() {
        return this.suppressExceptions(Consumer.DO_NOTHING);
    }

    @Pure
    @Capturable
    public static <INPUT, EXCEPTION extends Exception> FailableConsumer<INPUT, EXCEPTION> compose(@Captured FailableConsumer<? super INPUT, ? extends EXCEPTION> consumer0, @Captured FailableConsumer<? super INPUT, ? extends EXCEPTION> consumer1) {
        return input -> {
            consumer0.consume(input);
            consumer1.consume(input);
        };
    }

    @Pure
    @Capturable
    default public <SUBTYPE extends INPUT> FailableConsumer<SUBTYPE, EXCEPTION> before(@Captured FailableConsumer<? super SUBTYPE, ? extends EXCEPTION> consumer) {
        return input -> {
            this.consume(input);
            consumer.consume((Object)input);
        };
    }

    @Pure
    @Capturable
    default public <SUBTYPE extends INPUT> FailableConsumer<SUBTYPE, EXCEPTION> after(@Captured FailableConsumer<? super SUBTYPE, ? extends EXCEPTION> consumer) {
        return input -> {
            consumer.consume((Object)input);
            this.consume(input);
        };
    }

    @Pure
    @Capturable
    default public <INITIAL_INPUT> FailableConsumer<INITIAL_INPUT, EXCEPTION> after(FailableUnaryFunction<? super INITIAL_INPUT, ? extends INPUT, ? extends EXCEPTION> function) {
        return input -> this.consume(function.evaluate((Object)input));
    }

    @Pure
    default public FailableUnaryFunction<INPUT, Void, EXCEPTION> asFunction() {
        return input -> {
            this.consume(input);
            return null;
        };
    }

    @Pure
    default public FailableConsumer<INPUT, EXCEPTION> synchronize() {
        return input -> {
            FailableConsumer failableConsumer = this;
            synchronized (failableConsumer) {
                this.consume(input);
            }
        };
    }
}

