/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.failable;

import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.generics.Unspecifiable;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.functional.failable.FailableConsumer;
import net.digitalid.utility.functional.interfaces.Collector;
import net.digitalid.utility.functional.interfaces.Consumer;
import net.digitalid.utility.validation.annotations.type.Mutable;

@Mutable
public interface FailableCollector<@Specifiable INPUT, @Specifiable RESULT, @Unspecifiable COLLECT_EXCEPTION extends Exception, @Unspecifiable RESULT_EXCEPTION extends Exception>
extends FailableConsumer<INPUT, COLLECT_EXCEPTION> {
    @Pure
    @Capturable
    public RESULT getResult() throws RESULT_EXCEPTION;

    @Pure
    @Capturable
    default public Collector<INPUT, RESULT> suppressExceptions(final @Captured Consumer<? super Exception> handler, final @Captured RESULT defaultResult) {
        return new Collector<INPUT, RESULT>(){

            @Override
            @Impure
            public void consume(@Captured INPUT input) {
                try {
                    FailableCollector.this.consume(input);
                }
                catch (Exception exception) {
                    handler.consume(exception);
                }
            }

            @Override
            @Pure
            @Capturable
            public RESULT getResult() {
                try {
                    return FailableCollector.this.getResult();
                }
                catch (Exception exception) {
                    handler.consume(exception);
                    return defaultResult;
                }
            }
        };
    }

    @Pure
    @Capturable
    default public Collector<INPUT, RESULT> suppressExceptions(@Captured Consumer<? super Exception> handler) {
        return this.suppressExceptions(handler, null);
    }

    @Pure
    @Capturable
    default public Collector<INPUT, RESULT> suppressExceptions(@Captured RESULT defaultResult) {
        return this.suppressExceptions(Consumer.DO_NOTHING, defaultResult);
    }

    @Pure
    @Capturable
    default public Collector<INPUT, RESULT> suppressExceptions() {
        return this.suppressExceptions(Consumer.DO_NOTHING, null);
    }

    @Pure
    default public FailableCollector<INPUT, RESULT, COLLECT_EXCEPTION, RESULT_EXCEPTION> synchronize() {
        return new FailableCollector<INPUT, RESULT, COLLECT_EXCEPTION, RESULT_EXCEPTION>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Impure
            public void consume(@Captured INPUT input) throws Exception {
                FailableCollector failableCollector = FailableCollector.this;
                synchronized (failableCollector) {
                    FailableCollector.this.consume(input);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Pure
            @Capturable
            public RESULT getResult() throws Exception {
                FailableCollector failableCollector = FailableCollector.this;
                synchronized (failableCollector) {
                    return FailableCollector.this.getResult();
                }
            }
        };
    }
}

