/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.failable;

import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.generics.Unspecifiable;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.functional.failable.FailableBinaryFunction;
import net.digitalid.utility.functional.failable.FailableUnaryOperator;
import net.digitalid.utility.functional.interfaces.BinaryOperator;
import net.digitalid.utility.functional.interfaces.Consumer;
import net.digitalid.utility.validation.annotations.type.Functional;
import net.digitalid.utility.validation.annotations.type.Immutable;

@Immutable
@Functional
public interface FailableBinaryOperator<@Specifiable TYPE, @Unspecifiable EXCEPTION extends Exception>
extends FailableBinaryFunction<TYPE, TYPE, TYPE, EXCEPTION> {
    @Pure
    default public BinaryOperator<TYPE> suppressExceptions(@Captured Consumer<? super Exception> handler, @Captured TYPE defaultOutput) {
        return (input0, input1) -> {
            try {
                return this.evaluate(input0, input1);
            }
            catch (Exception exception) {
                handler.consume(exception);
                return defaultOutput;
            }
        };
    }

    @Pure
    default public BinaryOperator<TYPE> suppressExceptions(@Captured Consumer<? super Exception> handler) {
        return this.suppressExceptions((Consumer)handler, (Object)null);
    }

    @Pure
    default public BinaryOperator<TYPE> suppressExceptions(@Captured TYPE defaultOutput) {
        return this.suppressExceptions(Consumer.DO_NOTHING, (Object)defaultOutput);
    }

    @Pure
    default public BinaryOperator<TYPE> suppressExceptions() {
        return this.suppressExceptions(Consumer.DO_NOTHING, (Object)null);
    }

    @Pure
    public static <TYPE, EXCEPTION extends Exception> FailableBinaryOperator<TYPE, EXCEPTION> compose(FailableBinaryOperator<TYPE, ? extends EXCEPTION> binaryOperator, FailableUnaryOperator<TYPE, ? extends EXCEPTION> unaryOperator) {
        return (input0, input1) -> unaryOperator.evaluate(binaryOperator.evaluate(input0, input1));
    }

    @Pure
    default public FailableBinaryOperator<TYPE, EXCEPTION> before(FailableUnaryOperator<TYPE, ? extends EXCEPTION> operator) {
        return (input0, input1) -> operator.evaluate(this.evaluate(input0, input1));
    }

    @Pure
    public static <TYPE, EXCEPTION extends Exception> FailableBinaryOperator<TYPE, EXCEPTION> compose(FailableUnaryOperator<TYPE, ? extends EXCEPTION> unaryOperator0, FailableUnaryOperator<TYPE, ? extends EXCEPTION> unaryOperator1, FailableBinaryOperator<TYPE, ? extends EXCEPTION> binaryOperator) {
        return (input0, input1) -> binaryOperator.evaluate(unaryOperator0.evaluate(input0), unaryOperator1.evaluate(input1));
    }

    @Pure
    default public FailableBinaryOperator<TYPE, EXCEPTION> after(FailableUnaryOperator<TYPE, ? extends EXCEPTION> operator0, FailableUnaryOperator<TYPE, ? extends EXCEPTION> operator1) {
        return (input0, input1) -> this.evaluate(operator0.evaluate(input0), operator1.evaluate(input1));
    }

    @Pure
    default public FailableBinaryOperator<TYPE, EXCEPTION> replaceNull(@Captured TYPE defaultOutput) {
        return (input0, input1) -> input0 != null && input1 != null ? this.evaluate(input0, input1) : defaultOutput;
    }

    @Pure
    default public FailableBinaryOperator<TYPE, EXCEPTION> propagateNull() {
        return this.replaceNull((Object)null);
    }
}

