/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.failable;

import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.generics.Unspecifiable;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.annotations.ownership.NonCaptured;
import net.digitalid.utility.annotations.parameter.Unmodified;
import net.digitalid.utility.functional.failable.FailableUnaryFunction;
import net.digitalid.utility.functional.interfaces.BinaryFunction;
import net.digitalid.utility.functional.interfaces.Consumer;
import net.digitalid.utility.tuples.Pair;
import net.digitalid.utility.validation.annotations.type.Functional;
import net.digitalid.utility.validation.annotations.type.Immutable;

@Immutable
@Functional
public interface FailableBinaryFunction<@Specifiable INPUT0, @Specifiable INPUT1, @Specifiable OUTPUT, @Unspecifiable EXCEPTION extends Exception> {
    @Pure
    public OUTPUT evaluate(@NonCaptured @Unmodified INPUT0 var1, @NonCaptured @Unmodified INPUT1 var2) throws EXCEPTION;

    @Pure
    default public OUTPUT evaluate(Pair<INPUT0, INPUT1> pair) throws EXCEPTION {
        return this.evaluate(pair.get0(), pair.get1());
    }

    @Pure
    default public BinaryFunction<INPUT0, INPUT1, OUTPUT> suppressExceptions(@Captured Consumer<? super Exception> handler, @Captured OUTPUT defaultOutput) {
        return (input0, input1) -> {
            try {
                return this.evaluate(input0, input1);
            }
            catch (Exception exception) {
                handler.consume(exception);
                return defaultOutput;
            }
        };
    }

    @Pure
    default public BinaryFunction<INPUT0, INPUT1, OUTPUT> suppressExceptions(@Captured Consumer<? super Exception> handler) {
        return this.suppressExceptions(handler, null);
    }

    @Pure
    default public BinaryFunction<INPUT0, INPUT1, OUTPUT> suppressExceptions(@Captured OUTPUT defaultOutput) {
        return this.suppressExceptions(Consumer.DO_NOTHING, defaultOutput);
    }

    @Pure
    default public BinaryFunction<INPUT0, INPUT1, OUTPUT> suppressExceptions() {
        return this.suppressExceptions(Consumer.DO_NOTHING, null);
    }

    @Pure
    public static <INPUT0, INPUT1, INTERMEDIATE, OUTPUT, EXCEPTION extends Exception> FailableBinaryFunction<INPUT0, INPUT1, OUTPUT, EXCEPTION> compose(FailableBinaryFunction<? super INPUT0, ? super INPUT1, ? extends INTERMEDIATE, ? extends EXCEPTION> binaryFunction, FailableUnaryFunction<? super INTERMEDIATE, ? extends OUTPUT, ? extends EXCEPTION> unaryFunction) {
        return (input0, input1) -> unaryFunction.evaluate((Object)binaryFunction.evaluate(input0, input1));
    }

    @Pure
    default public <FINAL_OUTPUT> FailableBinaryFunction<INPUT0, INPUT1, FINAL_OUTPUT, EXCEPTION> before(FailableUnaryFunction<? super OUTPUT, ? extends FINAL_OUTPUT, ? extends EXCEPTION> function) {
        return (input0, input1) -> function.evaluate((OUTPUT)this.evaluate(input0, input1));
    }

    @Pure
    public static <INPUT0, INPUT1, INTERMEDIATE0, INTERMEDIATE1, OUTPUT, EXCEPTION extends Exception> FailableBinaryFunction<INPUT0, INPUT1, OUTPUT, EXCEPTION> compose(FailableUnaryFunction<? super INPUT0, ? extends INTERMEDIATE0, ? extends EXCEPTION> unaryFunction0, FailableUnaryFunction<? super INPUT1, ? extends INTERMEDIATE1, ? extends EXCEPTION> unaryFunction1, FailableBinaryFunction<? super INTERMEDIATE0, ? super INTERMEDIATE1, ? extends OUTPUT, ? extends EXCEPTION> binaryFunction) {
        return (input0, input1) -> binaryFunction.evaluate((Object)unaryFunction0.evaluate((Object)input0), (Object)unaryFunction1.evaluate((Object)input1));
    }

    @Pure
    default public <INITIAL_INPUT0, INITIAL_INPUT1> FailableBinaryFunction<INITIAL_INPUT0, INITIAL_INPUT1, OUTPUT, EXCEPTION> after(FailableUnaryFunction<? super INITIAL_INPUT0, ? extends INPUT0, ? extends EXCEPTION> function0, FailableUnaryFunction<? super INITIAL_INPUT1, ? extends INPUT1, ? extends EXCEPTION> function1) {
        return (input0, input1) -> this.evaluate(function0.evaluate((Object)input0), function1.evaluate((Object)input1));
    }

    @Pure
    default public FailableBinaryFunction<INPUT0, INPUT1, OUTPUT, EXCEPTION> replaceNull(@Captured OUTPUT defaultOutput) {
        return (input0, input1) -> input0 != null && input1 != null ? this.evaluate(input0, input1) : defaultOutput;
    }

    @Pure
    default public FailableBinaryFunction<INPUT0, INPUT1, OUTPUT, EXCEPTION> propagateNull() {
        return this.replaceNull(null);
    }
}

