/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.set;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.circumfixes.Circumfix;
import net.digitalid.utility.collections.array.FreezableArray;
import net.digitalid.utility.collections.collection.FreezableCollection;
import net.digitalid.utility.collections.collection.ReadOnlyCollection;
import net.digitalid.utility.collections.iterator.FreezableIterator;
import net.digitalid.utility.collections.list.FreezableList;
import net.digitalid.utility.collections.map.FreezableMap;
import net.digitalid.utility.collections.set.FreezableLinkedHashSet;
import net.digitalid.utility.collections.set.FreezableSet;
import net.digitalid.utility.collections.set.ReadOnlySet;
import net.digitalid.utility.contracts.Ensure;
import net.digitalid.utility.contracts.Require;
import net.digitalid.utility.functional.failable.FailableBinaryOperator;
import net.digitalid.utility.functional.failable.FailableCollector;
import net.digitalid.utility.functional.failable.FailableConsumer;
import net.digitalid.utility.functional.failable.FailablePredicate;
import net.digitalid.utility.functional.failable.FailableUnaryFunction;
import net.digitalid.utility.functional.iterables.FiniteIterable;
import net.digitalid.utility.functional.iterables.InfiniteIterable;
import net.digitalid.utility.functional.iterators.ReadOnlyIterator;
import net.digitalid.utility.tuples.Pair;
import net.digitalid.utility.validation.annotations.math.NonNegative;

class FreezableLinkedHashSetSubclass<E>
extends FreezableLinkedHashSet<E> {
    FreezableLinkedHashSetSubclass(@NonNegative int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.validate();
    }

    FreezableLinkedHashSetSubclass(@NonNegative int initialCapacity, Iterable<? extends E> iterable) {
        super(initialCapacity, iterable);
        this.validate();
    }

    public <T> T castTo(Class<T> targetClass) {
        Object result = super.castTo(targetClass);
        Ensure.that((result == this ? 1 : 0) != 0).orThrow("The result has to be <this> but was $.", new Object[]{result});
        return (T)result;
    }

    public boolean hasSize(int arg0) {
        Require.that((arg0 >= 0 ? 1 : 0) != 0).orThrow("The arg0 has to be non-negative but was $.", new Object[]{arg0});
        boolean result = super.hasSize(arg0);
        return result;
    }

    public boolean sizeAtMost(int arg0) {
        Require.that((arg0 >= 0 ? 1 : 0) != 0).orThrow("The arg0 has to be non-negative but was $.", new Object[]{arg0});
        boolean result = super.sizeAtMost(arg0);
        return result;
    }

    public boolean sizeAtLeast(int arg0) {
        Require.that((arg0 > 0 ? 1 : 0) != 0).orThrow("The arg0 has to be positive but was $.", new Object[]{arg0});
        boolean result = super.sizeAtLeast(arg0);
        return result;
    }

    public E get(int index) {
        Object result = super.get(index);
        return (E)result;
    }

    public FiniteIterable<E> limit(int arg0) {
        Require.that((arg0 > 0 ? 1 : 0) != 0).orThrow("The arg0 has to be positive but was $.", new Object[]{arg0});
        FiniteIterable result = super.limit(arg0);
        return result;
    }

    public FiniteIterable<E> extract(int arg0, int arg1) {
        Require.that((arg0 > 0 ? 1 : 0) != 0).orThrow("The arg0 has to be positive but was $.", new Object[]{arg0});
        Require.that((arg1 > 0 ? 1 : 0) != 0).orThrow("The arg1 has to be positive but was $.", new Object[]{arg1});
        FiniteIterable result = super.extract(arg0, arg1);
        return result;
    }

    public <TYPE> FiniteIterable<Pair<E, TYPE>> zipShortest(FiniteIterable<? extends TYPE> iterable) {
        FiniteIterable result = super.zipShortest(iterable);
        return result;
    }

    public <TYPE> InfiniteIterable<Pair<E, TYPE>> zipLongest(InfiniteIterable<? extends TYPE> iterable) {
        InfiniteIterable result = super.zipLongest(iterable);
        return result;
    }

    public boolean isSingle() {
        boolean result = super.isSingle();
        return result;
    }

    public boolean isEmptyOrSingle() {
        boolean result = super.isEmptyOrSingle();
        return result;
    }

    public FiniteIterable<E> filter(FailablePredicate<? super E, ?> predicate) {
        FiniteIterable result = super.filter(predicate);
        return result;
    }

    public FiniteIterable<E> filterNot(FailablePredicate<? super E, ?> predicate) {
        FiniteIterable result = super.filterNot(predicate);
        return result;
    }

    public FiniteIterable<E> filterNulls() {
        FiniteIterable result = super.filterNulls();
        return result;
    }

    public <TYPE> FiniteIterable<TYPE> map(FailableUnaryFunction<? super E, ? extends TYPE, ?> function) {
        FiniteIterable result = super.map(function);
        return result;
    }

    public <TYPE> FiniteIterable<TYPE> instanceOf(Class<TYPE> type) {
        FiniteIterable result = super.instanceOf(type);
        return result;
    }

    public FiniteIterable<E> skip(int arg0) {
        Require.that((arg0 > 0 ? 1 : 0) != 0).orThrow("The arg0 has to be positive but was $.", new Object[]{arg0});
        FiniteIterable result = super.skip(arg0);
        return result;
    }

    public <TYPE> FiniteIterable<Pair<E, TYPE>> zipShortest(InfiniteIterable<? extends TYPE> iterable) {
        FiniteIterable result = super.zipShortest(iterable);
        return result;
    }

    public <TYPE> FiniteIterable<Pair<E, TYPE>> zipLongest(FiniteIterable<? extends TYPE> iterable) {
        FiniteIterable result = super.zipLongest(iterable);
        return result;
    }

    public <TYPE> FiniteIterable<TYPE> flatten(int arg0) {
        Require.that((arg0 > 0 ? 1 : 0) != 0).orThrow("The arg0 has to be positive but was $.", new Object[]{arg0});
        FiniteIterable result = super.flatten(arg0);
        return result;
    }

    public <TYPE> FiniteIterable<TYPE> flattenOne() {
        FiniteIterable result = super.flattenOne();
        return result;
    }

    public <TYPE> FiniteIterable<TYPE> flattenAll() {
        FiniteIterable result = super.flattenAll();
        return result;
    }

    public boolean equals(FiniteIterable<?> iterable) {
        boolean result = super.equals(iterable);
        return result;
    }

    public E getFirst(E arg0) {
        Object result = super.getFirst(arg0);
        return (E)result;
    }

    public E getFirstOrNull() {
        Object result = super.getFirstOrNull();
        return (E)result;
    }

    @Override
    public E getFirst() {
        Object result = super.getFirst();
        return result;
    }

    public E getLast(E arg0) {
        Object result = super.getLast(arg0);
        return (E)result;
    }

    public E getLastOrNull() {
        Object result = super.getLastOrNull();
        return (E)result;
    }

    @Override
    public E getLast() {
        Object result = super.getLast();
        return result;
    }

    public int indexOf(Object arg0) {
        int result = super.indexOf(arg0);
        Ensure.that(((long)result >= -1L ? 1 : 0) != 0).orThrow("The result has to be greater than or equal to -1l but was $.", new Object[]{result});
        return result;
    }

    public int lastIndexOf(Object arg0) {
        int result = super.lastIndexOf(arg0);
        Ensure.that(((long)result >= -1L ? 1 : 0) != 0).orThrow("The result has to be greater than or equal to -1l but was $.", new Object[]{result});
        return result;
    }

    public int count(Object arg0) {
        int result = super.count(arg0);
        Ensure.that((result >= 0 ? 1 : 0) != 0).orThrow("The result has to be non-negative but was $.", new Object[]{result});
        return result;
    }

    @Override
    public boolean containsAll(FiniteIterable<?> iterable) {
        boolean result = super.containsAll(iterable);
        return result;
    }

    public boolean containsNull() {
        boolean result = super.containsNull();
        return result;
    }

    public boolean containsDuplicates() {
        boolean result = super.containsDuplicates();
        return result;
    }

    public FiniteIterable<E> distinct() {
        FiniteIterable result = super.distinct();
        return result;
    }

    public <EXCEPTION extends Exception> FiniteIterable<E> doForEach(FailableConsumer<? super E, ? extends EXCEPTION> arg0) throws EXCEPTION {
        FiniteIterable result = super.doForEach(arg0);
        Ensure.that((result == this ? 1 : 0) != 0).orThrow("The result has to be <this> but was $.", new Object[]{result});
        return result;
    }

    public FiniteIterable<E> intersect(FiniteIterable<? super E> iterable) {
        FiniteIterable result = super.intersect(iterable);
        return result;
    }

    public FiniteIterable<E> exclude(FiniteIterable<? super E> iterable) {
        FiniteIterable result = super.exclude(iterable);
        return result;
    }

    public FiniteIterable<E> combine(FiniteIterable<? extends E> iterable) {
        FiniteIterable result = super.combine(iterable);
        return result;
    }

    public InfiniteIterable<E> combine(InfiniteIterable<? extends E> iterable) {
        InfiniteIterable result = super.combine(iterable);
        return result;
    }

    public InfiniteIterable<E> repeated() {
        InfiniteIterable result = super.repeated();
        return result;
    }

    public <EXCEPTION extends Exception> E findFirst(FailablePredicate<? super E, ? extends EXCEPTION> arg0, E arg1) throws EXCEPTION {
        Object result = super.findFirst(arg0, arg1);
        return (E)result;
    }

    public <EXCEPTION extends Exception> E findFirst(FailablePredicate<? super E, ? extends EXCEPTION> predicate) throws EXCEPTION {
        Object result = super.findFirst(predicate);
        return (E)result;
    }

    public <EXCEPTION extends Exception> E findLast(FailablePredicate<? super E, ? extends EXCEPTION> arg0, E arg1) throws EXCEPTION {
        Object result = super.findLast(arg0, arg1);
        return (E)result;
    }

    public <EXCEPTION extends Exception> E findLast(FailablePredicate<? super E, ? extends EXCEPTION> predicate) throws EXCEPTION {
        Object result = super.findLast(predicate);
        return (E)result;
    }

    public <EXCEPTION extends Exception> E findUnique(FailablePredicate<? super E, ? extends EXCEPTION> predicate) throws EXCEPTION {
        Object result = super.findUnique(predicate);
        return (E)result;
    }

    public <EXCEPTION extends Exception> boolean matchAny(FailablePredicate<? super E, ? extends EXCEPTION> predicate) throws EXCEPTION {
        boolean result = super.matchAny(predicate);
        return result;
    }

    public <EXCEPTION extends Exception> boolean matchAll(FailablePredicate<? super E, ? extends EXCEPTION> predicate) throws EXCEPTION {
        boolean result = super.matchAll(predicate);
        return result;
    }

    public <EXCEPTION extends Exception> boolean matchNone(FailablePredicate<? super E, ? extends EXCEPTION> predicate) throws EXCEPTION {
        boolean result = super.matchNone(predicate);
        return result;
    }

    public <EXCEPTION extends Exception> E reduce(FailableBinaryOperator<E, ? extends EXCEPTION> arg0, E arg1) throws EXCEPTION {
        Object result = super.reduce(arg0, arg1);
        return (E)result;
    }

    public <EXCEPTION extends Exception> E reduce(FailableBinaryOperator<E, ? extends EXCEPTION> operator) throws EXCEPTION {
        Object result = super.reduce(operator);
        return (E)result;
    }

    public <RESULT, COLLECT_EXCEPTION extends Exception, RESULT_EXCEPTION extends Exception> RESULT collect(FailableCollector<? super E, ? extends RESULT, ? extends COLLECT_EXCEPTION, ? extends RESULT_EXCEPTION> arg0) throws COLLECT_EXCEPTION, RESULT_EXCEPTION {
        Object result = super.collect(arg0);
        return (RESULT)result;
    }

    public boolean isOrdered(boolean strictly, boolean ascending) {
        boolean result = super.isOrdered(strictly, ascending);
        return result;
    }

    public boolean isAscending() {
        boolean result = super.isAscending();
        return result;
    }

    public boolean isStrictlyAscending() {
        boolean result = super.isStrictlyAscending();
        return result;
    }

    public boolean isDescending() {
        boolean result = super.isDescending();
        return result;
    }

    public boolean isStrictlyDescending() {
        boolean result = super.isStrictlyDescending();
        return result;
    }

    public FiniteIterable<E> sorted(Comparator<? super E> comparator) {
        FiniteIterable result = super.sorted(comparator);
        return result;
    }

    public FiniteIterable<E> sorted() {
        FiniteIterable result = super.sorted();
        return result;
    }

    @Override
    public FiniteIterable<E> reversed() {
        FiniteIterable result = super.reversed();
        return result;
    }

    public E min(Comparator<? super E> arg0, E arg1) {
        Object result = super.min(arg0, arg1);
        return (E)result;
    }

    public E min(Comparator<? super E> comparator) {
        Object result = super.min(comparator);
        return (E)result;
    }

    public E min(E arg0) {
        Object result = super.min(arg0);
        return (E)result;
    }

    public E min() {
        Object result = super.min();
        return (E)result;
    }

    public E max(Comparator<? super E> arg0, E arg1) {
        Object result = super.max(arg0, arg1);
        return (E)result;
    }

    public E max(Comparator<? super E> comparator) {
        Object result = super.max(comparator);
        return (E)result;
    }

    public E max(E arg0) {
        Object result = super.max(arg0);
        return (E)result;
    }

    public E max() {
        Object result = super.max();
        return (E)result;
    }

    public long sumAsLong() {
        long result = super.sumAsLong();
        return result;
    }

    public double sumAsDouble() {
        double result = super.sumAsDouble();
        return result;
    }

    public double average() {
        double result = super.average();
        return result;
    }

    public String join(CharSequence prefix, CharSequence suffix, CharSequence empty, CharSequence delimiter) {
        String result = super.join(prefix, suffix, empty, delimiter);
        return result;
    }

    public String join(CharSequence prefix, CharSequence suffix, CharSequence empty) {
        String result = super.join(prefix, suffix, empty);
        return result;
    }

    public String join(CharSequence prefix, CharSequence suffix) {
        String result = super.join(prefix, suffix);
        return result;
    }

    public String join(Circumfix fixes, CharSequence empty, CharSequence delimiter) {
        String result = super.join(fixes, empty, delimiter);
        return result;
    }

    public String join(Circumfix fixes, CharSequence empty) {
        String result = super.join(fixes, empty);
        return result;
    }

    public String join(Circumfix fixes) {
        String result = super.join(fixes);
        return result;
    }

    public String join(CharSequence delimiter) {
        String result = super.join(delimiter);
        return result;
    }

    public String join() {
        String result = super.join();
        return result;
    }

    public E[] toGenericArray() {
        Object[] result = super.toGenericArray();
        return result;
    }

    public List<E> toList() {
        List result = super.toList();
        return result;
    }

    public Set<E> toSet() {
        Set result = super.toSet();
        return result;
    }

    public <KEY, EXCEPTION extends Exception> Map<KEY, E> toMap(FailableUnaryFunction<? super E, ? extends KEY, ? extends EXCEPTION> function) throws EXCEPTION {
        Map result = super.toMap(function);
        return result;
    }

    public <KEY, EXCEPTION extends Exception> Map<KEY, List<E>> groupBy(FailableUnaryFunction<? super E, ? extends KEY, ? extends EXCEPTION> function) throws EXCEPTION {
        Map result = super.groupBy(function);
        return result;
    }

    public <EXCEPTION extends Exception> FiniteIterable<E> evaluate() throws EXCEPTION {
        FiniteIterable result = super.evaluate();
        return result;
    }

    public int size(int arg0) {
        Require.that((arg0 > 0 ? 1 : 0) != 0).orThrow("The arg0 has to be positive but was $.", new Object[]{arg0});
        int result = super.size(arg0);
        Ensure.that((result >= 0 ? 1 : 0) != 0).orThrow("The result has to be non-negative but was $.", new Object[]{result});
        return result;
    }

    @Override
    public FreezableArray<E> toFreezableArray() {
        FreezableArray result = super.toFreezableArray();
        Ensure.that((result != null ? 1 : 0) != 0).orThrow("The result may not be null.", new Object[]{result});
        Ensure.that((result == null || !result.isFrozen() ? 1 : 0) != 0).orThrow("The result has to be null or may not be frozen.", new Object[]{result});
        return result;
    }

    @Override
    public FreezableList<E> toFreezableList() {
        FreezableList result = super.toFreezableList();
        Ensure.that((result != null ? 1 : 0) != 0).orThrow("The result may not be null.", new Object[]{result});
        Ensure.that((result == null || !result.isFrozen() ? 1 : 0) != 0).orThrow("The result has to be null or may not be frozen.", new Object[]{result});
        return result;
    }

    @Override
    public FreezableSet<E> toFreezableSet() {
        FreezableSet result = super.toFreezableSet();
        Ensure.that((result != null ? 1 : 0) != 0).orThrow("The result may not be null.", new Object[]{result});
        Ensure.that((result == null || !result.isFrozen() ? 1 : 0) != 0).orThrow("The result has to be null or may not be frozen.", new Object[]{result});
        return result;
    }

    @Override
    public <KEY, EXCEPTION extends Exception> FreezableMap<KEY, E> toFreezableMap(FailableUnaryFunction<? super E, ? extends KEY, ? extends EXCEPTION> function) throws EXCEPTION {
        Require.that((function != null ? 1 : 0) != 0).orThrow("The function may not be null.", new Object[]{function});
        FreezableMap<? extends KEY, ? super E> result = super.toFreezableMap(function);
        Ensure.that((result != null ? 1 : 0) != 0).orThrow("The result may not be null.", new Object[]{result});
        Ensure.that((result == null || !result.isFrozen() ? 1 : 0) != 0).orThrow("The result has to be null or may not be frozen.", new Object[]{result});
        return result;
    }

    @Override
    public boolean containsAll(FreezableCollection<?> collection) {
        Require.that((collection != null ? 1 : 0) != 0).orThrow("The collection may not be null.", new Object[]{collection});
        boolean result = super.containsAll(collection);
        return result;
    }

    @Override
    public boolean addAll(FiniteIterable<? extends E> iterable) {
        Require.that((iterable != null ? 1 : 0) != 0).orThrow("The iterable may not be null.", new Object[]{iterable});
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'addAll' may only be called on non-frozen objects.", new Object[0]);
        boolean result = super.addAll(iterable);
        return result;
    }

    @Override
    public boolean addAll(FreezableCollection<? extends E> collection) {
        Require.that((collection != null ? 1 : 0) != 0).orThrow("The collection may not be null.", new Object[]{collection});
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'addAll' may only be called on non-frozen objects.", new Object[0]);
        boolean result = super.addAll(collection);
        return result;
    }

    @Override
    public boolean removeAll(FiniteIterable<?> iterable) {
        Require.that((iterable != null ? 1 : 0) != 0).orThrow("The iterable may not be null.", new Object[]{iterable});
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'removeAll' may only be called on non-frozen objects.", new Object[0]);
        boolean result = super.removeAll(iterable);
        return result;
    }

    @Override
    public boolean removeAll(FreezableCollection<?> collection) {
        Require.that((collection != null ? 1 : 0) != 0).orThrow("The collection may not be null.", new Object[]{collection});
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'removeAll' may only be called on non-frozen objects.", new Object[0]);
        boolean result = super.removeAll(collection);
        return result;
    }

    @Override
    public boolean retainAll(FiniteIterable<?> iterable) {
        Require.that((iterable != null ? 1 : 0) != 0).orThrow("The iterable may not be null.", new Object[]{iterable});
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'retainAll' may only be called on non-frozen objects.", new Object[0]);
        boolean result = super.retainAll(iterable);
        return result;
    }

    @Override
    public boolean retainAll(FreezableCollection<?> collection) {
        Require.that((collection != null ? 1 : 0) != 0).orThrow("The collection may not be null.", new Object[]{collection});
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'retainAll' may only be called on non-frozen objects.", new Object[0]);
        boolean result = super.retainAll(collection);
        return result;
    }

    @Override
    public boolean isFrozen() {
        boolean result = super.isFrozen();
        return result;
    }

    @Override
    public ReadOnlySet<E> freeze() {
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'freeze' may only be called on non-frozen objects.", new Object[0]);
        ReadOnlyCollection result = super.freeze();
        Ensure.that((result != null ? 1 : 0) != 0).orThrow("The result may not be null.", new Object[]{result});
        Ensure.that((result == null || result.isFrozen() ? 1 : 0) != 0).orThrow("The result has to be null or frozen.", new Object[]{result});
        return result;
    }

    @Override
    public ReadOnlyIterator<E> iterator() {
        ReadOnlyIterator result = super.iterator();
        Ensure.that((result != null ? 1 : 0) != 0).orThrow("The result may not be null.", new Object[]{result});
        return result;
    }

    @Override
    public FreezableIterator<E> freezableIterator() {
        FreezableIterator result = super.freezableIterator();
        Ensure.that((result != null ? 1 : 0) != 0).orThrow("The result may not be null.", new Object[]{result});
        return result;
    }

    @Override
    public boolean add(E element) {
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'add' may only be called on non-frozen objects.", new Object[0]);
        boolean result = super.add(element);
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Require.that((collection != null ? 1 : 0) != 0).orThrow("The collection may not be null.", new Object[]{collection});
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'addAll' may only be called on non-frozen objects.", new Object[0]);
        boolean result = super.addAll(collection);
        return result;
    }

    @Override
    public boolean remove(Object object) {
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'remove' may only be called on non-frozen objects.", new Object[0]);
        boolean result = super.remove(object);
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        Require.that((collection != null ? 1 : 0) != 0).orThrow("The collection may not be null.", new Object[]{collection});
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'removeAll' may only be called on non-frozen objects.", new Object[0]);
        boolean result = super.removeAll(collection);
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        Require.that((collection != null ? 1 : 0) != 0).orThrow("The collection may not be null.", new Object[]{collection});
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'retainAll' may only be called on non-frozen objects.", new Object[0]);
        boolean result = super.retainAll(collection);
        return result;
    }

    @Override
    public void clear() {
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'clear' may only be called on non-frozen objects.", new Object[0]);
        super.clear();
    }

    @Pure
    public void validate() {
        super.validate();
    }
}

