/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.set;

import net.digitalid.utility.collections.set.FreezableLinkedHashSet;
import net.digitalid.utility.collections.set.FreezableLinkedHashSetSubclass;
import net.digitalid.utility.validation.annotations.math.NonNegative;
import net.digitalid.utility.validation.annotations.method.Chainable;

public class FreezableLinkedHashSetBuilder<E> {
    public static <E> InnerFreezableLinkedHashSetBuilder<E> withInitialCapacity(@NonNegative int initialCapacity) {
        return new InnerFreezableLinkedHashSetBuilder().withInitialCapacity(initialCapacity);
    }

    public static <E> InnerFreezableLinkedHashSetBuilder<E> withLoadFactor(float loadFactor) {
        return new InnerFreezableLinkedHashSetBuilder().withLoadFactor(loadFactor);
    }

    public static <E> FreezableLinkedHashSet<E> build() {
        return new InnerFreezableLinkedHashSetBuilder().build();
    }

    public static <E> FreezableLinkedHashSet<E> buildWithInitialCapacity(@NonNegative int initialCapacity) {
        return new InnerFreezableLinkedHashSetBuilder().withInitialCapacity(initialCapacity).build();
    }

    public static <E> FreezableLinkedHashSet<E> buildWithLoadFactor(float loadFactor) {
        return new InnerFreezableLinkedHashSetBuilder().withLoadFactor(loadFactor).build();
    }

    public static class InnerFreezableLinkedHashSetBuilder<E> {
        @NonNegative
        private int initialCapacity = 16;
        private float loadFactor = 0.75f;

        private InnerFreezableLinkedHashSetBuilder() {
        }

        @Chainable
        public InnerFreezableLinkedHashSetBuilder<E> withInitialCapacity(@NonNegative int initialCapacity) {
            this.initialCapacity = initialCapacity;
            return this;
        }

        @Chainable
        public InnerFreezableLinkedHashSetBuilder<E> withLoadFactor(float loadFactor) {
            this.loadFactor = loadFactor;
            return this;
        }

        public FreezableLinkedHashSet<E> build() {
            return new FreezableLinkedHashSetSubclass(this.initialCapacity, this.loadFactor);
        }
    }
}

