/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.set;

import net.digitalid.utility.collections.set.FreezableHashSet;
import net.digitalid.utility.collections.set.FreezableHashSetSubclass;
import net.digitalid.utility.validation.annotations.math.NonNegative;
import net.digitalid.utility.validation.annotations.method.Chainable;

public class FreezableHashSetBuilder<E> {
    public static <E> InnerFreezableHashSetBuilder<E> withInitialCapacity(@NonNegative int initialCapacity) {
        return new InnerFreezableHashSetBuilder().withInitialCapacity(initialCapacity);
    }

    public static <E> InnerFreezableHashSetBuilder<E> withLoadFactor(float loadFactor) {
        return new InnerFreezableHashSetBuilder().withLoadFactor(loadFactor);
    }

    public static <E> FreezableHashSet<E> build() {
        return new InnerFreezableHashSetBuilder().build();
    }

    public static <E> FreezableHashSet<E> buildWithInitialCapacity(@NonNegative int initialCapacity) {
        return new InnerFreezableHashSetBuilder().withInitialCapacity(initialCapacity).build();
    }

    public static <E> FreezableHashSet<E> buildWithLoadFactor(float loadFactor) {
        return new InnerFreezableHashSetBuilder().withLoadFactor(loadFactor).build();
    }

    public static class InnerFreezableHashSetBuilder<E> {
        @NonNegative
        private int initialCapacity = 16;
        private float loadFactor = 0.75f;

        private InnerFreezableHashSetBuilder() {
        }

        @Chainable
        public InnerFreezableHashSetBuilder<E> withInitialCapacity(@NonNegative int initialCapacity) {
            this.initialCapacity = initialCapacity;
            return this;
        }

        @Chainable
        public InnerFreezableHashSetBuilder<E> withLoadFactor(float loadFactor) {
            this.loadFactor = loadFactor;
            return this;
        }

        public FreezableHashSet<E> build() {
            return new FreezableHashSetSubclass(this.initialCapacity, this.loadFactor);
        }
    }
}

