/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.set;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.annotations.ownership.NonCaptured;
import net.digitalid.utility.annotations.parameter.Unmodified;
import net.digitalid.utility.circumfixes.Brackets;
import net.digitalid.utility.circumfixes.Circumfix;
import net.digitalid.utility.collections.collection.FreezableCollection;
import net.digitalid.utility.collections.iterator.FreezableIterator;
import net.digitalid.utility.collections.set.FreezableHashSetBuilder;
import net.digitalid.utility.collections.set.FreezableHashSetSubclass;
import net.digitalid.utility.collections.set.FreezableSet;
import net.digitalid.utility.collections.set.ReadOnlySet;
import net.digitalid.utility.freezable.annotations.Freezable;
import net.digitalid.utility.freezable.annotations.NonFrozen;
import net.digitalid.utility.freezable.annotations.NonFrozenRecipient;
import net.digitalid.utility.functional.iterables.FiniteIterable;
import net.digitalid.utility.functional.iterators.ReadOnlyIterableIterator;
import net.digitalid.utility.functional.iterators.ReadOnlyIterator;
import net.digitalid.utility.generator.annotations.generators.GenerateBuilder;
import net.digitalid.utility.generator.annotations.generators.GenerateSubclass;
import net.digitalid.utility.validation.annotations.generation.Default;
import net.digitalid.utility.validation.annotations.generation.Recover;
import net.digitalid.utility.validation.annotations.math.NonNegative;

@GenerateBuilder
@GenerateSubclass
@Freezable(value=ReadOnlySet.class)
public abstract class FreezableHashSet<E>
extends HashSet<E>
implements FreezableSet<E> {
    private boolean frozen = false;

    @Recover
    protected FreezableHashSet(@NonNegative @Default(value="16") int initialCapacity, @Default(value="0.75f") float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableHashSet<E> withElement(@Captured E element) {
        FreezableHashSet<E> set = FreezableHashSetBuilder.build();
        set.add(element);
        return set;
    }

    protected FreezableHashSet(@NonNegative int initialCapacity, @NonCaptured @Unmodified Iterable<? extends E> iterable) {
        super(initialCapacity);
        for (E element : iterable) {
            super.add(element);
        }
    }

    @Pure
    @SafeVarargs
    @Capturable
    @NonFrozen
    public static <E> FreezableHashSet<E> withElements(E ... elements) {
        return elements == null ? null : new FreezableHashSetSubclass<E>(elements.length, Arrays.asList(elements));
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableHashSet<E> withElementsOf(FiniteIterable<? extends E> iterable) {
        return iterable == null ? null : new FreezableHashSetSubclass<E>(iterable.size(), iterable);
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableHashSet<E> withElementsOf(@NonCaptured @Unmodified Collection<? extends E> collection) {
        return collection == null ? null : new FreezableHashSetSubclass<E>(collection.size(), collection);
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableHashSet<E> withElementsOf(@NonCaptured @Unmodified FreezableCollection<? extends E> collection) {
        return collection == null ? null : new FreezableHashSetSubclass<E>(collection.size(), collection);
    }

    @Pure
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public ReadOnlySet<E> freeze() {
        this.frozen = true;
        return this;
    }

    @Override
    @Pure
    @Capturable
    @NonFrozen
    public FreezableHashSet<E> clone() {
        return new FreezableHashSetSubclass(this.size(), this);
    }

    @Override
    @Pure
    @Capturable
    public ReadOnlyIterator<E> iterator() {
        return ReadOnlyIterableIterator.with(super.iterator());
    }

    @Override
    @Pure
    @Capturable
    public FreezableIterator<E> freezableIterator() {
        return FreezableIterator.with(super.iterator(), this);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean add(@Captured E element) {
        return super.add(element);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean addAll(@NonCaptured @Unmodified Collection<? extends E> collection) {
        return super.addAll(collection);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean remove(@NonCaptured @Unmodified Object object) {
        return super.remove(object);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean removeAll(@NonCaptured @Unmodified Collection<?> collection) {
        return super.removeAll(collection);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean retainAll(@NonCaptured @Unmodified Collection<?> collection) {
        return FreezableSet.super.retainAll(collection);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public void clear() {
        super.clear();
    }

    @Override
    @Pure
    public String toString() {
        return this.join((Circumfix)Brackets.CURLY);
    }
}

