/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.set;

import java.util.Set;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.annotations.ownership.Shared;
import net.digitalid.utility.annotations.parameter.Modified;
import net.digitalid.utility.circumfixes.Brackets;
import net.digitalid.utility.circumfixes.Circumfix;
import net.digitalid.utility.collections.collection.BackedFreezableCollection;
import net.digitalid.utility.collections.set.BackedFreezableSetSubclass;
import net.digitalid.utility.collections.set.FreezableHashSet;
import net.digitalid.utility.collections.set.FreezableSet;
import net.digitalid.utility.collections.set.ReadOnlySet;
import net.digitalid.utility.freezable.FreezableInterface;
import net.digitalid.utility.freezable.annotations.Freezable;
import net.digitalid.utility.freezable.annotations.NonFrozen;
import net.digitalid.utility.freezable.annotations.NonFrozenRecipient;
import net.digitalid.utility.generator.annotations.generators.GenerateSubclass;

@GenerateSubclass
@Freezable(value=ReadOnlySet.class)
public abstract class BackedFreezableSet<E>
extends BackedFreezableCollection<E>
implements FreezableSet<E> {
    private final Set<E> set;

    protected BackedFreezableSet(FreezableInterface freezable, Set<E> set) {
        super(freezable, set);
        this.set = set;
    }

    @Pure
    @Capturable
    public static <E> BackedFreezableSet<E> with(@Shared @Modified FreezableInterface freezable, @Captured Set<E> set) {
        return new BackedFreezableSetSubclass<E>(freezable, set);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public ReadOnlySet<E> freeze() {
        super.freeze();
        return this;
    }

    @Override
    @Pure
    @Capturable
    @NonFrozen
    public FreezableSet<E> clone() {
        return FreezableHashSet.withElementsOf(this.set);
    }

    @Override
    @Pure
    public String toString() {
        return this.join((Circumfix)Brackets.CURLY);
    }
}

