/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.map;

import java.util.Collection;
import java.util.Map;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.annotations.ownership.NonCapturable;
import net.digitalid.utility.annotations.ownership.NonCaptured;
import net.digitalid.utility.annotations.parameter.Unmodified;
import net.digitalid.utility.collections.collection.FreezableCollection;
import net.digitalid.utility.collections.map.ReadOnlyMap;
import net.digitalid.utility.collections.set.FreezableSet;
import net.digitalid.utility.freezable.FreezableInterface;
import net.digitalid.utility.freezable.annotations.Freezable;
import net.digitalid.utility.freezable.annotations.NonFrozenRecipient;
import net.digitalid.utility.functional.iterables.FiniteIterable;
import net.digitalid.utility.immutable.entry.ReadOnlyEntrySet;
import net.digitalid.utility.validation.annotations.method.Chainable;

@Freezable(value=ReadOnlyMap.class)
public interface FreezableMap<K, V>
extends ReadOnlyMap<K, V>,
Map<K, V>,
FreezableInterface {
    @Override
    @Pure
    public boolean isEmpty();

    @Impure
    @NonFrozenRecipient
    @Chainable
    public ReadOnlyMap<K, V> freeze();

    @Override
    @Pure
    @NonCapturable
    public FreezableSet<K> keySet();

    @Override
    @Pure
    @NonCapturable
    public FreezableCollection<V> values();

    @Override
    @Pure
    @NonCapturable
    public ReadOnlyEntrySet<K, V> entrySet();

    @Override
    @Impure
    @NonFrozenRecipient
    default public void putAll(ReadOnlyMap<? extends K, ? extends V> map) {
        map.entrySet().doForEach(entry -> this.put(entry.getKey(), entry.getValue()));
    }

    @Impure
    @NonFrozenRecipient
    default public void removeAll(FiniteIterable<?> keys) {
        for (Object key : keys) {
            this.remove(key);
        }
    }

    @Impure
    @NonFrozenRecipient
    default public void removeAll(@NonCaptured @Unmodified Collection<?> keys) {
        for (Object key : keys) {
            this.remove(key);
        }
    }

    @Impure
    @NonFrozenRecipient
    default public void removeAll(@NonCaptured @Unmodified FreezableCollection<?> keys) {
        for (Object key : keys) {
            this.remove(key);
        }
    }

    @Impure
    @NonFrozenRecipient
    default public void removeAll(ReadOnlyMap<? extends K, ? extends V> map) {
        this.removeAll((FreezableCollection<?>)((Object)this.keySet()));
    }

    @Impure
    @NonFrozenRecipient
    @NonCapturable
    default public V putIfAbsentOrNullElseReturnPresent(@Captured K key, @Captured V value) {
        Object oldValue = this.get(key);
        if (oldValue != null) {
            return oldValue;
        }
        this.put(key, value);
        return value;
    }
}

