/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.map;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.collections.collection.FreezableCollection;
import net.digitalid.utility.collections.map.FreezableLinkedHashMap;
import net.digitalid.utility.collections.map.ReadOnlyMap;
import net.digitalid.utility.collections.set.FreezableSet;
import net.digitalid.utility.contracts.Ensure;
import net.digitalid.utility.contracts.Require;
import net.digitalid.utility.freezable.ReadOnlyInterface;
import net.digitalid.utility.functional.iterables.FiniteIterable;
import net.digitalid.utility.immutable.entry.ReadOnlyEntrySet;
import net.digitalid.utility.validation.annotations.math.NonNegative;

class FreezableLinkedHashMapSubclass<K, V>
extends FreezableLinkedHashMap<K, V> {
    FreezableLinkedHashMapSubclass(@NonNegative int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor, accessOrder);
        this.validate();
    }

    FreezableLinkedHashMapSubclass(Map<? extends K, ? extends V> map) {
        super(map);
        this.validate();
    }

    public <T> T castTo(Class<T> targetClass) {
        Object result = super.castTo(targetClass);
        Ensure.that((result == this ? 1 : 0) != 0).orThrow("The result has to be <this> but was $.", new Object[]{result});
        return (T)result;
    }

    public boolean isSingle() {
        boolean result = super.isSingle();
        return result;
    }

    public boolean isEmptyOrSingle() {
        boolean result = super.isEmptyOrSingle();
        return result;
    }

    @Override
    public void putAll(ReadOnlyMap<? extends K, ? extends V> map) {
        Require.that((map != null ? 1 : 0) != 0).orThrow("The map may not be null.", new Object[]{map});
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'putAll' may only be called on non-frozen objects.", new Object[0]);
        super.putAll(map);
    }

    @Override
    public void removeAll(FiniteIterable<?> keys) {
        Require.that((keys != null ? 1 : 0) != 0).orThrow("The keys may not be null.", new Object[]{keys});
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'removeAll' may only be called on non-frozen objects.", new Object[0]);
        super.removeAll(keys);
    }

    @Override
    public void removeAll(Collection<?> keys) {
        Require.that((keys != null ? 1 : 0) != 0).orThrow("The keys may not be null.", new Object[]{keys});
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'removeAll' may only be called on non-frozen objects.", new Object[0]);
        super.removeAll(keys);
    }

    @Override
    public void removeAll(FreezableCollection<?> keys) {
        Require.that((keys != null ? 1 : 0) != 0).orThrow("The keys may not be null.", new Object[]{keys});
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'removeAll' may only be called on non-frozen objects.", new Object[0]);
        super.removeAll(keys);
    }

    @Override
    public void removeAll(ReadOnlyMap<? extends K, ? extends V> map) {
        Require.that((map != null ? 1 : 0) != 0).orThrow("The map may not be null.", new Object[]{map});
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'removeAll' may only be called on non-frozen objects.", new Object[0]);
        super.removeAll(map);
    }

    @Override
    public V putIfAbsentOrNullElseReturnPresent(K key, V value) {
        Require.that((value != null ? 1 : 0) != 0).orThrow("The value may not be null.", new Object[]{value});
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'putIfAbsentOrNullElseReturnPresent' may only be called on non-frozen objects.", new Object[0]);
        V result = super.putIfAbsentOrNullElseReturnPresent(key, value);
        Ensure.that((result != null ? 1 : 0) != 0).orThrow("The result may not be null.", new Object[]{result});
        return result;
    }

    @Override
    public boolean isEmpty() {
        boolean result = super.isEmpty();
        return result;
    }

    @Override
    public boolean isFrozen() {
        boolean result = super.isFrozen();
        return result;
    }

    @Override
    public ReadOnlyMap<K, V> freeze() {
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'freeze' may only be called on non-frozen objects.", new Object[0]);
        ReadOnlyInterface result = super.freeze();
        Ensure.that((result == this ? 1 : 0) != 0).orThrow("The result has to be <this> but was $.", new Object[]{result});
        Ensure.that((result != null ? 1 : 0) != 0).orThrow("The result may not be null.", new Object[]{result});
        Ensure.that((result == null || result.isFrozen() ? 1 : 0) != 0).orThrow("The result has to be null or frozen.", new Object[]{result});
        return result;
    }

    @Override
    public FreezableSet<K> keySet() {
        Set result = super.keySet();
        Ensure.that((result != null ? 1 : 0) != 0).orThrow("The result may not be null.", new Object[]{result});
        return result;
    }

    @Override
    public FreezableCollection<V> values() {
        Collection result = super.values();
        Ensure.that((result != null ? 1 : 0) != 0).orThrow("The result may not be null.", new Object[]{result});
        return result;
    }

    @Override
    public ReadOnlyEntrySet<K, V> entrySet() {
        ReadOnlyEntrySet result = super.entrySet();
        Ensure.that((result != null ? 1 : 0) != 0).orThrow("The result may not be null.", new Object[]{result});
        return result;
    }

    @Override
    public V put(K key, V value) {
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'put' may only be called on non-frozen objects.", new Object[0]);
        V result = super.put(key, value);
        return result;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Require.that((map != null ? 1 : 0) != 0).orThrow("The map may not be null.", new Object[]{map});
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'putAll' may only be called on non-frozen objects.", new Object[0]);
        super.putAll(map);
    }

    @Override
    public V remove(Object object) {
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'remove' may only be called on non-frozen objects.", new Object[0]);
        Object result = super.remove(object);
        return result;
    }

    @Override
    public void clear() {
        Require.that((!this.isFrozen() ? 1 : 0) != 0).orThrow("The method 'clear' may only be called on non-frozen objects.", new Object[0]);
        super.clear();
    }

    @Pure
    public void validate() {
        super.validate();
    }
}

