/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.map;

import net.digitalid.utility.collections.map.FreezableLinkedHashMap;
import net.digitalid.utility.collections.map.FreezableLinkedHashMapSubclass;
import net.digitalid.utility.validation.annotations.math.NonNegative;
import net.digitalid.utility.validation.annotations.method.Chainable;

public class FreezableLinkedHashMapBuilder<K, V> {
    public static <K, V> InnerFreezableLinkedHashMapBuilder<K, V> withInitialCapacity(@NonNegative int initialCapacity) {
        return new InnerFreezableLinkedHashMapBuilder().withInitialCapacity(initialCapacity);
    }

    public static <K, V> InnerFreezableLinkedHashMapBuilder<K, V> withLoadFactor(float loadFactor) {
        return new InnerFreezableLinkedHashMapBuilder().withLoadFactor(loadFactor);
    }

    public static <K, V> InnerFreezableLinkedHashMapBuilder<K, V> withAccessOrder(boolean accessOrder) {
        return new InnerFreezableLinkedHashMapBuilder().withAccessOrder(accessOrder);
    }

    public static <K, V> FreezableLinkedHashMap<K, V> build() {
        return new InnerFreezableLinkedHashMapBuilder().build();
    }

    public static <K, V> FreezableLinkedHashMap<K, V> buildWithInitialCapacity(@NonNegative int initialCapacity) {
        return new InnerFreezableLinkedHashMapBuilder().withInitialCapacity(initialCapacity).build();
    }

    public static <K, V> FreezableLinkedHashMap<K, V> buildWithLoadFactor(float loadFactor) {
        return new InnerFreezableLinkedHashMapBuilder().withLoadFactor(loadFactor).build();
    }

    public static <K, V> FreezableLinkedHashMap<K, V> buildWithAccessOrder(boolean accessOrder) {
        return new InnerFreezableLinkedHashMapBuilder().withAccessOrder(accessOrder).build();
    }

    public static class InnerFreezableLinkedHashMapBuilder<K, V> {
        @NonNegative
        private int initialCapacity = 16;
        private float loadFactor = 0.75f;
        private boolean accessOrder = false;

        private InnerFreezableLinkedHashMapBuilder() {
        }

        @Chainable
        public InnerFreezableLinkedHashMapBuilder<K, V> withInitialCapacity(@NonNegative int initialCapacity) {
            this.initialCapacity = initialCapacity;
            return this;
        }

        @Chainable
        public InnerFreezableLinkedHashMapBuilder<K, V> withLoadFactor(float loadFactor) {
            this.loadFactor = loadFactor;
            return this;
        }

        @Chainable
        public InnerFreezableLinkedHashMapBuilder<K, V> withAccessOrder(boolean accessOrder) {
            this.accessOrder = accessOrder;
            return this;
        }

        public FreezableLinkedHashMap<K, V> build() {
            return new FreezableLinkedHashMapSubclass(this.initialCapacity, this.loadFactor, this.accessOrder);
        }
    }
}

