/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.map;

import java.util.LinkedHashMap;
import java.util.Map;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.annotations.ownership.NonCapturable;
import net.digitalid.utility.annotations.ownership.NonCaptured;
import net.digitalid.utility.annotations.parameter.Unmodified;
import net.digitalid.utility.circumfixes.Brackets;
import net.digitalid.utility.circumfixes.Circumfix;
import net.digitalid.utility.collections.collection.BackedFreezableCollection;
import net.digitalid.utility.collections.collection.FreezableCollection;
import net.digitalid.utility.collections.map.FreezableLinkedHashMapSubclass;
import net.digitalid.utility.collections.map.FreezableMap;
import net.digitalid.utility.collections.map.ReadOnlyMap;
import net.digitalid.utility.collections.set.BackedFreezableSet;
import net.digitalid.utility.collections.set.FreezableSet;
import net.digitalid.utility.freezable.FreezableInterface;
import net.digitalid.utility.freezable.annotations.Freezable;
import net.digitalid.utility.freezable.annotations.NonFrozen;
import net.digitalid.utility.freezable.annotations.NonFrozenRecipient;
import net.digitalid.utility.generator.annotations.generators.GenerateBuilder;
import net.digitalid.utility.generator.annotations.generators.GenerateSubclass;
import net.digitalid.utility.immutable.entry.ReadOnlyEntrySet;
import net.digitalid.utility.validation.annotations.generation.Default;
import net.digitalid.utility.validation.annotations.generation.Recover;
import net.digitalid.utility.validation.annotations.math.NonNegative;
import net.digitalid.utility.validation.annotations.method.Chainable;

@GenerateBuilder
@GenerateSubclass
@Freezable(value=ReadOnlyMap.class)
public abstract class FreezableLinkedHashMap<K, V>
extends LinkedHashMap<K, V>
implements FreezableMap<K, V> {
    private boolean frozen = false;

    @Override
    @Pure
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Recover
    protected FreezableLinkedHashMap(@NonNegative @Default(value="16") int initialCapacity, @Default(value="0.75f") float loadFactor, @Default(value="false") boolean accessOrder) {
        super(initialCapacity, loadFactor, accessOrder);
    }

    protected FreezableLinkedHashMap(@NonCaptured @Unmodified Map<? extends K, ? extends V> map) {
        super(map);
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <K, V> FreezableLinkedHashMap<K, V> withMappingsOf(ReadOnlyMap<? extends K, ? extends V> map) {
        return map == null ? null : new FreezableLinkedHashMapSubclass((Map)((Object)map));
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <K, V> FreezableLinkedHashMap<K, V> withMappingsOf(@NonCaptured @Unmodified Map<? extends K, ? extends V> map) {
        return map == null ? null : new FreezableLinkedHashMapSubclass<K, V>(map);
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <K, V> FreezableLinkedHashMap<K, V> withMappingsOf(@NonCaptured @Unmodified FreezableMap<? extends K, ? extends V> map) {
        return map == null ? null : new FreezableLinkedHashMapSubclass<K, V>(map);
    }

    @Pure
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    @Impure
    @NonFrozenRecipient
    @Chainable
    public ReadOnlyMap<K, V> freeze() {
        this.frozen = true;
        return this;
    }

    @Override
    @Pure
    @Capturable
    @NonFrozen
    public FreezableLinkedHashMap<K, V> clone() {
        return new FreezableLinkedHashMapSubclass(this);
    }

    @Override
    @Pure
    @NonCapturable
    public FreezableSet<K> keySet() {
        return BackedFreezableSet.with((FreezableInterface)this, super.keySet());
    }

    @Override
    @Pure
    @NonCapturable
    public FreezableCollection<V> values() {
        return BackedFreezableCollection.with(this, super.values());
    }

    @Override
    @Pure
    @NonCapturable
    public ReadOnlyEntrySet<K, V> entrySet() {
        return ReadOnlyEntrySet.with(super.entrySet());
    }

    @Override
    @Impure
    @NonFrozenRecipient
    @Capturable
    public V put(@Captured K key, @Captured V value) {
        return super.put(key, value);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public void putAll(@NonCaptured @Unmodified Map<? extends K, ? extends V> map) {
        super.putAll(map);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    @Capturable
    public V remove(@NonCaptured @Unmodified Object object) {
        return super.remove(object);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public void clear() {
        super.clear();
    }

    @Override
    @Pure
    public String toString() {
        return this.entrySet().map(entry -> entry == null ? "null" : entry.getKey() + ": " + entry.getValue()).join((Circumfix)Brackets.CURLY);
    }
}

