/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.map;

import net.digitalid.utility.collections.map.FreezableHashMap;
import net.digitalid.utility.collections.map.FreezableHashMapSubclass;
import net.digitalid.utility.validation.annotations.math.NonNegative;
import net.digitalid.utility.validation.annotations.method.Chainable;

public class FreezableHashMapBuilder<K, V> {
    public static <K, V> InnerFreezableHashMapBuilder<K, V> withInitialCapacity(@NonNegative int initialCapacity) {
        return new InnerFreezableHashMapBuilder().withInitialCapacity(initialCapacity);
    }

    public static <K, V> InnerFreezableHashMapBuilder<K, V> withLoadFactor(float loadFactor) {
        return new InnerFreezableHashMapBuilder().withLoadFactor(loadFactor);
    }

    public static <K, V> FreezableHashMap<K, V> build() {
        return new InnerFreezableHashMapBuilder().build();
    }

    public static <K, V> FreezableHashMap<K, V> buildWithInitialCapacity(@NonNegative int initialCapacity) {
        return new InnerFreezableHashMapBuilder().withInitialCapacity(initialCapacity).build();
    }

    public static <K, V> FreezableHashMap<K, V> buildWithLoadFactor(float loadFactor) {
        return new InnerFreezableHashMapBuilder().withLoadFactor(loadFactor).build();
    }

    public static class InnerFreezableHashMapBuilder<K, V> {
        @NonNegative
        private int initialCapacity = 16;
        private float loadFactor = 0.75f;

        private InnerFreezableHashMapBuilder() {
        }

        @Chainable
        public InnerFreezableHashMapBuilder<K, V> withInitialCapacity(@NonNegative int initialCapacity) {
            this.initialCapacity = initialCapacity;
            return this;
        }

        @Chainable
        public InnerFreezableHashMapBuilder<K, V> withLoadFactor(float loadFactor) {
            this.loadFactor = loadFactor;
            return this;
        }

        public FreezableHashMap<K, V> build() {
            return new FreezableHashMapSubclass(this.initialCapacity, this.loadFactor);
        }
    }
}

