/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.list;

import java.util.Collection;
import java.util.List;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.NonCapturable;
import net.digitalid.utility.annotations.ownership.NonCaptured;
import net.digitalid.utility.annotations.parameter.Modified;
import net.digitalid.utility.annotations.parameter.Unmodified;
import net.digitalid.utility.collections.collection.FreezableCollection;
import net.digitalid.utility.collections.list.ReadOnlyList;
import net.digitalid.utility.freezable.annotations.Freezable;
import net.digitalid.utility.freezable.annotations.NonFrozenRecipient;
import net.digitalid.utility.validation.annotations.index.Index;
import net.digitalid.utility.validation.annotations.index.IndexForInsertion;
import net.digitalid.utility.validation.annotations.math.relative.GreaterThanOrEqualTo;
import net.digitalid.utility.validation.annotations.method.Chainable;

@Freezable(value=ReadOnlyList.class)
public interface FreezableList<E>
extends ReadOnlyList<E>,
List<E>,
FreezableCollection<E> {
    @Override
    @Impure
    @NonFrozenRecipient
    @Chainable
    public ReadOnlyList<E> freeze();

    @Override
    @Pure
    @NonCapturable
    public FreezableList<E> subList(@Index int var1, @IndexForInsertion int var2);

    @Override
    @Pure
    default public boolean isEmpty() {
        return FreezableCollection.super.isEmpty();
    }

    @Override
    @Pure
    @NonCapturable
    default public E get(@Index int index) {
        return (E)FreezableCollection.super.get(index);
    }

    @Override
    @Pure
    @GreaterThanOrEqualTo(value=-1L)
    default public @GreaterThanOrEqualTo(value=-1L) int indexOf(@NonCaptured @Unmodified Object object) {
        return FreezableCollection.super.indexOf(object);
    }

    @Override
    @Pure
    @GreaterThanOrEqualTo(value=-1L)
    default public @GreaterThanOrEqualTo(value=-1L) int lastIndexOf(@NonCaptured @Unmodified Object object) {
        return FreezableCollection.super.lastIndexOf(object);
    }

    @Override
    @Pure
    default public boolean contains(@NonCaptured @Unmodified Object object) {
        return FreezableCollection.super.contains(object);
    }

    @Override
    @Pure
    default public boolean containsAll(@NonCaptured @Unmodified Collection<?> collection) {
        return FreezableCollection.super.containsAll(collection);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    default public boolean removeAll(@NonCaptured @Unmodified Collection<?> collection) {
        return FreezableCollection.super.removeAll(collection);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    default public boolean retainAll(@NonCaptured @Unmodified Collection<?> collection) {
        return FreezableCollection.super.retainAll(collection);
    }

    @Override
    @Pure
    @Capturable
    default public Object[] toArray() {
        return FreezableCollection.super.toArray();
    }

    @Override
    @Pure
    @Capturable
    default public <T> T[] toArray(@NonCaptured @Modified T[] array) {
        return FreezableCollection.super.toArray(array);
    }
}

