/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.list;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.annotations.ownership.NonCapturable;
import net.digitalid.utility.annotations.ownership.NonCaptured;
import net.digitalid.utility.annotations.parameter.Unmodified;
import net.digitalid.utility.collections.collection.FreezableCollection;
import net.digitalid.utility.collections.iterator.FreezableIterator;
import net.digitalid.utility.collections.list.BackedFreezableList;
import net.digitalid.utility.collections.list.FreezableLinkedListSubclass;
import net.digitalid.utility.collections.list.FreezableList;
import net.digitalid.utility.collections.list.ReadOnlyList;
import net.digitalid.utility.freezable.FreezableInterface;
import net.digitalid.utility.freezable.annotations.Freezable;
import net.digitalid.utility.freezable.annotations.NonFrozen;
import net.digitalid.utility.freezable.annotations.NonFrozenRecipient;
import net.digitalid.utility.functional.iterables.FiniteIterable;
import net.digitalid.utility.functional.iterators.ReadOnlyIterableIterator;
import net.digitalid.utility.functional.iterators.ReadOnlyIterator;
import net.digitalid.utility.functional.iterators.ReadOnlyListIterator;
import net.digitalid.utility.generator.annotations.generators.GenerateSubclass;
import net.digitalid.utility.validation.annotations.index.Index;
import net.digitalid.utility.validation.annotations.index.IndexForInsertion;

@GenerateSubclass
@Freezable(value=ReadOnlyList.class)
public abstract class FreezableLinkedList<E>
extends LinkedList<E>
implements FreezableList<E> {
    private boolean frozen = false;

    protected FreezableLinkedList() {
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableLinkedList<E> withNoElements() {
        return new FreezableLinkedListSubclass();
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableLinkedList<E> withElement(@Captured E element) {
        FreezableLinkedListSubclass<E> list = new FreezableLinkedListSubclass<E>();
        ((FreezableLinkedList)list).add(element);
        return list;
    }

    protected FreezableLinkedList(@NonCaptured @Unmodified Iterable<? extends E> iterable) {
        for (E element : iterable) {
            super.add(element);
        }
    }

    @Pure
    @SafeVarargs
    @Capturable
    @NonFrozen
    public static <E> FreezableLinkedList<E> withElements(E ... elements) {
        return elements == null ? null : new FreezableLinkedListSubclass<E>(Arrays.asList(elements));
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableLinkedList<E> withElementsOf(FiniteIterable<? extends E> iterable) {
        return iterable == null ? null : new FreezableLinkedListSubclass<E>(iterable);
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableLinkedList<E> withElementsOf(@NonCaptured @Unmodified Collection<? extends E> collection) {
        return collection == null ? null : new FreezableLinkedListSubclass<E>(collection);
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableLinkedList<E> withElementsOf(@NonCaptured @Unmodified FreezableCollection<? extends E> collection) {
        return collection == null ? null : new FreezableLinkedListSubclass<E>(collection);
    }

    @Pure
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public ReadOnlyList<E> freeze() {
        this.frozen = true;
        return this;
    }

    @Override
    @Pure
    @Capturable
    @NonFrozen
    public FreezableLinkedList<E> clone() {
        return new FreezableLinkedListSubclass(this);
    }

    @Override
    @Pure
    @NonCapturable
    public E get(@Index int index) {
        return super.get(index);
    }

    @Override
    @Pure
    @Capturable
    public ReadOnlyIterator<E> iterator() {
        return ReadOnlyIterableIterator.with(super.iterator());
    }

    @Override
    @Pure
    @Capturable
    public FreezableIterator<E> freezableIterator() {
        return FreezableIterator.with(super.listIterator(0), this);
    }

    @Override
    @Pure
    @Capturable
    public ReadOnlyIterator<E> descendingIterator() {
        return ReadOnlyIterableIterator.with(super.descendingIterator());
    }

    @Override
    @Pure
    @Capturable
    public ReadOnlyListIterator<E> listIterator() {
        return ReadOnlyListIterator.with(super.listIterator());
    }

    @Override
    @Pure
    @Capturable
    public ReadOnlyListIterator<E> listIterator(@IndexForInsertion int index) {
        return ReadOnlyListIterator.with(super.listIterator(index));
    }

    @Override
    @Pure
    @NonCapturable
    public FreezableList<E> subList(@Index int fromIndex, @IndexForInsertion int toIndex) {
        return BackedFreezableList.with((FreezableInterface)this, super.subList(fromIndex, toIndex));
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean add(@Captured E element) {
        return super.add(element);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public void add(@IndexForInsertion int index, @Captured E element) {
        super.add(index, element);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public void addFirst(@Captured E element) {
        super.addFirst(element);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public void addLast(@Captured E element) {
        super.addLast(element);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean addAll(@NonCaptured @Unmodified Collection<? extends E> collection) {
        return super.addAll(collection);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean addAll(@IndexForInsertion int index, @NonCaptured @Unmodified Collection<? extends E> collection) {
        return super.addAll(index, collection);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean offer(@Captured E element) {
        return super.offer(element);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean offerFirst(@Captured E element) {
        return super.offerFirst(element);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean offerLast(@Captured E element) {
        return super.offerLast(element);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    @Capturable
    public E remove() {
        return super.remove();
    }

    @Override
    @Impure
    @NonFrozenRecipient
    @Capturable
    public E removeFirst() {
        return super.removeFirst();
    }

    @Override
    @Impure
    @NonFrozenRecipient
    @Capturable
    public E removeLast() {
        return super.removeLast();
    }

    @Override
    @Impure
    @NonFrozenRecipient
    @Capturable
    public E remove(@Index int index) {
        return super.remove(index);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean remove(@NonCaptured @Unmodified Object object) {
        return super.remove(object);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean removeFirstOccurrence(@NonCaptured @Unmodified Object object) {
        return super.removeFirstOccurrence(object);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean removeLastOccurrence(@NonCaptured @Unmodified Object object) {
        return super.removeLastOccurrence(object);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    protected void removeRange(@Index int fromIndex, @IndexForInsertion int toIndex) {
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean removeAll(@NonCaptured @Unmodified Collection<?> collection) {
        return FreezableList.super.removeAll(collection);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    @Capturable
    public E poll() {
        return super.poll();
    }

    @Override
    @Impure
    @NonFrozenRecipient
    @Capturable
    public E pollFirst() {
        return super.pollFirst();
    }

    @Override
    @Impure
    @NonFrozenRecipient
    @Capturable
    public E pollLast() {
        return super.pollLast();
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public void push(@Captured E element) {
        super.push(element);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    @Capturable
    public E pop() {
        return super.pop();
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public E set(@Index int index, @Captured E element) {
        return super.set(index, element);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public void clear() {
        super.clear();
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean retainAll(@NonCaptured @Unmodified Collection<?> collection) {
        return FreezableList.super.retainAll(collection);
    }
}

