/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.annotations.ownership.NonCapturable;
import net.digitalid.utility.annotations.ownership.NonCaptured;
import net.digitalid.utility.annotations.parameter.Unmodified;
import net.digitalid.utility.collections.collection.FreezableCollection;
import net.digitalid.utility.collections.iterator.FreezableIterator;
import net.digitalid.utility.collections.list.BackedFreezableList;
import net.digitalid.utility.collections.list.FreezableArrayListSubclass;
import net.digitalid.utility.collections.list.FreezableList;
import net.digitalid.utility.collections.list.ReadOnlyList;
import net.digitalid.utility.freezable.FreezableInterface;
import net.digitalid.utility.freezable.annotations.Freezable;
import net.digitalid.utility.freezable.annotations.NonFrozen;
import net.digitalid.utility.freezable.annotations.NonFrozenRecipient;
import net.digitalid.utility.functional.iterables.FiniteIterable;
import net.digitalid.utility.functional.iterators.ReadOnlyIterableIterator;
import net.digitalid.utility.functional.iterators.ReadOnlyIterator;
import net.digitalid.utility.functional.iterators.ReadOnlyListIterator;
import net.digitalid.utility.generator.annotations.generators.GenerateSubclass;
import net.digitalid.utility.validation.annotations.index.Index;
import net.digitalid.utility.validation.annotations.index.IndexForInsertion;
import net.digitalid.utility.validation.annotations.math.NonNegative;

@GenerateSubclass
@Freezable(value=ReadOnlyList.class)
public abstract class FreezableArrayList<E>
extends ArrayList<E>
implements FreezableList<E> {
    private boolean frozen = false;

    protected FreezableArrayList() {
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableArrayList<E> withNoElements() {
        return new FreezableArrayListSubclass();
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableArrayList<E> withElement(@Captured E element) {
        FreezableArrayListSubclass<E> list = new FreezableArrayListSubclass<E>();
        ((FreezableArrayList)list).add(element);
        return list;
    }

    protected FreezableArrayList(@NonNegative int initialCapacity) {
        super(initialCapacity);
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableArrayList<E> withInitialCapacity(@NonNegative int initialCapacity) {
        return new FreezableArrayListSubclass(initialCapacity);
    }

    protected FreezableArrayList(@NonNegative int initialCapacity, @NonCaptured @Unmodified Iterable<? extends E> iterable) {
        super(initialCapacity);
        for (E element : iterable) {
            super.add(element);
        }
    }

    @Pure
    @SafeVarargs
    @Capturable
    @NonFrozen
    public static <E> FreezableArrayList<E> withElements(E ... elements) {
        return elements == null ? null : new FreezableArrayListSubclass<E>(elements.length, Arrays.asList(elements));
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableArrayList<E> withElementsOf(FiniteIterable<? extends E> iterable) {
        return iterable == null ? null : new FreezableArrayListSubclass<E>(iterable.size(), iterable);
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableArrayList<E> withElementsOf(@NonCaptured @Unmodified Collection<? extends E> collection) {
        return collection == null ? null : new FreezableArrayListSubclass<E>(collection.size(), collection);
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableArrayList<E> withElementsOf(@NonCaptured @Unmodified FreezableCollection<? extends E> collection) {
        return collection == null ? null : new FreezableArrayListSubclass<E>(collection.size(), collection);
    }

    @Pure
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public ReadOnlyList<E> freeze() {
        this.frozen = true;
        return this;
    }

    @Override
    @Pure
    @Capturable
    @NonFrozen
    public FreezableArrayList<E> clone() {
        return new FreezableArrayListSubclass(this.size(), this);
    }

    @Override
    @Pure
    @Capturable
    public ReadOnlyIterator<E> iterator() {
        return ReadOnlyIterableIterator.with(super.iterator());
    }

    @Override
    @Pure
    @Capturable
    public FreezableIterator<E> freezableIterator() {
        return FreezableIterator.with(super.iterator(), this);
    }

    @Override
    @Pure
    @NonCapturable
    public E get(@Index int index) {
        return super.get(index);
    }

    @Override
    @Pure
    @Capturable
    public ReadOnlyListIterator<E> listIterator() {
        return ReadOnlyListIterator.with(super.listIterator());
    }

    @Override
    @Pure
    @Capturable
    public ReadOnlyListIterator<E> listIterator(@IndexForInsertion int index) {
        return ReadOnlyListIterator.with(super.listIterator(index));
    }

    @Override
    @Pure
    @NonCapturable
    public FreezableList<E> subList(@Index int fromIndex, @IndexForInsertion int toIndex) {
        return BackedFreezableList.with((FreezableInterface)this, super.subList(fromIndex, toIndex));
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean add(@Captured E element) {
        return super.add(element);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public void add(@IndexForInsertion int index, @Captured E element) {
        super.add(index, element);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean addAll(@NonCaptured @Unmodified Collection<? extends E> collection) {
        return super.addAll(collection);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean addAll(@IndexForInsertion int index, @NonCaptured @Unmodified Collection<? extends E> collection) {
        return super.addAll(index, collection);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    @Capturable
    public E remove(@Index int index) {
        return super.remove(index);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean remove(@NonCaptured @Unmodified Object object) {
        return super.remove(object);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    protected void removeRange(@Index int fromIndex, @IndexForInsertion int toIndex) {
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean removeAll(@NonCaptured @Unmodified Collection<?> collection) {
        return super.removeAll(collection);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean retainAll(@NonCaptured @Unmodified Collection<?> collection) {
        return super.retainAll(collection);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public void clear() {
        super.clear();
    }

    @Override
    @Impure
    @NonFrozenRecipient
    @Capturable
    public E set(@Index int index, @Captured E element) {
        return super.set(index, element);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public void ensureCapacity(@NonNegative int minCapacity) {
        super.ensureCapacity(minCapacity);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public void trimToSize() {
        super.trimToSize();
    }
}

