/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.list;

import java.util.Collection;
import java.util.List;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.annotations.ownership.NonCapturable;
import net.digitalid.utility.annotations.ownership.NonCaptured;
import net.digitalid.utility.annotations.ownership.Shared;
import net.digitalid.utility.annotations.parameter.Modified;
import net.digitalid.utility.annotations.parameter.Unmodified;
import net.digitalid.utility.circumfixes.Brackets;
import net.digitalid.utility.circumfixes.Circumfix;
import net.digitalid.utility.collections.collection.BackedFreezableCollection;
import net.digitalid.utility.collections.list.BackedFreezableListSubclass;
import net.digitalid.utility.collections.list.FreezableArrayList;
import net.digitalid.utility.collections.list.FreezableList;
import net.digitalid.utility.collections.list.ReadOnlyList;
import net.digitalid.utility.freezable.FreezableInterface;
import net.digitalid.utility.freezable.annotations.Freezable;
import net.digitalid.utility.freezable.annotations.NonFrozen;
import net.digitalid.utility.freezable.annotations.NonFrozenRecipient;
import net.digitalid.utility.functional.iterators.ReadOnlyListIterator;
import net.digitalid.utility.generator.annotations.generators.GenerateSubclass;
import net.digitalid.utility.validation.annotations.index.Index;
import net.digitalid.utility.validation.annotations.index.IndexForInsertion;

@GenerateSubclass
@Freezable(value=ReadOnlyList.class)
public abstract class BackedFreezableList<E>
extends BackedFreezableCollection<E>
implements FreezableList<E> {
    private final List<E> list;

    protected BackedFreezableList(FreezableInterface freezable, List<E> list) {
        super(freezable, list);
        this.list = list;
    }

    @Pure
    @Capturable
    public static <E> BackedFreezableList<E> with(@Shared @Modified FreezableInterface freezable, @Captured List<E> list) {
        return new BackedFreezableListSubclass<E>(freezable, list);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public ReadOnlyList<E> freeze() {
        super.freeze();
        return this;
    }

    @Override
    @Pure
    @Capturable
    @NonFrozen
    public FreezableList<E> clone() {
        return FreezableArrayList.withElementsOf(this.list);
    }

    @Override
    @Pure
    @NonCapturable
    public E get(@Index int index) {
        return this.list.get(index);
    }

    @Override
    @Pure
    @Capturable
    public ReadOnlyListIterator<E> listIterator() {
        return ReadOnlyListIterator.with(this.list.listIterator());
    }

    @Override
    @Pure
    @Capturable
    public ReadOnlyListIterator<E> listIterator(@IndexForInsertion int index) {
        return ReadOnlyListIterator.with(this.list.listIterator(index));
    }

    @Override
    @Pure
    @NonCapturable
    public FreezableList<E> subList(@Index int fromIndex, @IndexForInsertion int toIndex) {
        return BackedFreezableList.with((FreezableInterface)this, this.list.subList(fromIndex, toIndex));
    }

    @Override
    @Impure
    @NonFrozenRecipient
    @Capturable
    public E set(@Index int index, @Captured E element) {
        return this.list.set(index, element);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public void add(@IndexForInsertion int index, @Captured E element) {
        this.list.add(index, element);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    @Capturable
    public E remove(@Index int index) {
        return this.list.remove(index);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean addAll(@IndexForInsertion int index, @NonCaptured @Unmodified Collection<? extends E> collection) {
        return this.list.addAll(index, collection);
    }

    @Override
    @Pure
    public String toString() {
        return this.join((Circumfix)Brackets.SQUARE);
    }
}

