/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.annotations.ownership.Shared;
import net.digitalid.utility.collections.collection.FreezableCollection;
import net.digitalid.utility.collections.iterator.FreezableIteratorSubclass;
import net.digitalid.utility.contracts.Require;
import net.digitalid.utility.generator.annotations.generators.GenerateSubclass;
import net.digitalid.utility.validation.annotations.type.Mutable;

@Mutable
@GenerateSubclass
public abstract class FreezableIterator<E>
implements Iterator<E> {
    @Pure
    abstract Iterator<E> getIterator();

    @Pure
    abstract FreezableCollection<E> getCollection();

    @Pure
    public static <E> FreezableIterator<E> with(@Captured Iterator<E> iterator, @Shared FreezableCollection<E> collection) {
        return new FreezableIteratorSubclass<E>(iterator, collection);
    }

    @Override
    @Pure
    public boolean hasNext() {
        return this.getIterator().hasNext();
    }

    @Override
    @Impure
    public E next() throws NoSuchElementException {
        return this.getIterator().next();
    }

    @Override
    @Impure
    public void remove() throws IllegalStateException {
        Require.that((!this.getCollection().isFrozen() ? 1 : 0) != 0).orThrow("The underlying collection may not be frozen.", new Object[0]);
        this.getIterator().remove();
    }
}

