/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.iterable;

import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.collections.array.FreezableArray;
import net.digitalid.utility.collections.iterable.FreezableIterable;
import net.digitalid.utility.collections.list.FreezableLinkedList;
import net.digitalid.utility.collections.list.FreezableList;
import net.digitalid.utility.collections.map.FreezableLinkedHashMap;
import net.digitalid.utility.collections.map.FreezableLinkedHashMapBuilder;
import net.digitalid.utility.collections.map.FreezableMap;
import net.digitalid.utility.collections.set.FreezableLinkedHashSet;
import net.digitalid.utility.collections.set.FreezableSet;
import net.digitalid.utility.freezable.ReadOnlyInterface;
import net.digitalid.utility.freezable.annotations.NonFrozen;
import net.digitalid.utility.functional.failable.FailableUnaryFunction;
import net.digitalid.utility.functional.iterables.CollectionIterable;
import net.digitalid.utility.functional.iterators.ReadOnlyIterator;
import net.digitalid.utility.validation.annotations.type.ReadOnly;

@ReadOnly(value=FreezableIterable.class)
public interface ReadOnlyIterable<@Specifiable ELEMENT>
extends CollectionIterable<ELEMENT>,
ReadOnlyInterface {
    @Pure
    @Capturable
    @NonFrozen
    public FreezableIterable<ELEMENT> clone();

    @Pure
    @Capturable
    @NonFrozen
    default public FreezableArray<ELEMENT> toFreezableArray() {
        return FreezableArray.withElementsOf(this);
    }

    @Pure
    @Capturable
    @NonFrozen
    default public FreezableList<ELEMENT> toFreezableList() {
        return FreezableLinkedList.withElementsOf(this);
    }

    @Pure
    @Capturable
    @NonFrozen
    default public FreezableSet<ELEMENT> toFreezableSet() {
        return FreezableLinkedHashSet.withElementsOf(this);
    }

    @Pure
    @Capturable
    @NonFrozen
    default public <KEY, EXCEPTION extends Exception> FreezableMap<KEY, ELEMENT> toFreezableMap(FailableUnaryFunction<? super ELEMENT, ? extends KEY, ? extends EXCEPTION> function) throws EXCEPTION {
        FreezableLinkedHashMap result = FreezableLinkedHashMapBuilder.build();
        ReadOnlyIterator readOnlyIterator = this.iterator();
        while (readOnlyIterator.hasNext()) {
            Object element = readOnlyIterator.next();
            result.put(function.evaluate(element), element);
        }
        return result;
    }
}

