/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.collection;

import java.util.Collection;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.NonCaptured;
import net.digitalid.utility.annotations.parameter.Modified;
import net.digitalid.utility.annotations.parameter.Unmodified;
import net.digitalid.utility.collections.collection.ReadOnlyCollection;
import net.digitalid.utility.collections.iterable.FreezableIterable;
import net.digitalid.utility.collections.iterator.FreezableIterator;
import net.digitalid.utility.freezable.annotations.Freezable;
import net.digitalid.utility.freezable.annotations.NonFrozenRecipient;
import net.digitalid.utility.functional.iterables.FiniteIterable;
import net.digitalid.utility.validation.annotations.method.Chainable;

@Freezable(value=ReadOnlyCollection.class)
public interface FreezableCollection<E>
extends ReadOnlyCollection<E>,
Collection<E>,
FreezableIterable<E> {
    @Override
    @Impure
    @NonFrozenRecipient
    @Chainable
    public ReadOnlyCollection<E> freeze();

    @Override
    @Pure
    default public boolean isEmpty() {
        return ReadOnlyCollection.super.isEmpty();
    }

    @Override
    @Pure
    default public boolean contains(@NonCaptured @Unmodified Object object) {
        return ReadOnlyCollection.super.contains(object);
    }

    @Override
    @Pure
    default public boolean containsAll(@NonCaptured @Unmodified Collection<?> collection) {
        return ReadOnlyCollection.super.containsAll(collection);
    }

    @Override
    @Pure
    @Capturable
    default public Object[] toArray() {
        return ReadOnlyCollection.super.toArray();
    }

    @Override
    @Pure
    @Capturable
    default public <T> T[] toArray(@NonCaptured @Modified T[] array) {
        return ReadOnlyCollection.super.toArray((Object[])array);
    }

    @Pure
    @Capturable
    public FreezableIterator<E> freezableIterator();

    @Override
    @Impure
    @NonFrozenRecipient
    default public boolean addAll(FiniteIterable<? extends E> iterable) {
        boolean modified = false;
        for (Object element : iterable) {
            modified = this.add(element) || modified;
        }
        return modified;
    }

    @Override
    @Impure
    @NonFrozenRecipient
    default public boolean addAll(@NonCaptured @Unmodified FreezableCollection<? extends E> collection) {
        return this.addAll((FiniteIterable<? extends E>)collection);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    default public boolean removeAll(FiniteIterable<?> iterable) {
        boolean modified = false;
        FreezableIterator<E> iterator = this.freezableIterator();
        while (iterator.hasNext()) {
            if (!iterable.contains(iterator.next())) continue;
            iterator.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    @Impure
    @NonFrozenRecipient
    default public boolean removeAll(@NonCaptured @Unmodified Collection<?> collection) {
        return this.removeAll(FiniteIterable.of(collection));
    }

    @Override
    @Impure
    @NonFrozenRecipient
    default public boolean removeAll(@NonCaptured @Unmodified FreezableCollection<?> collection) {
        return this.removeAll((FiniteIterable<?>)collection);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    default public boolean retainAll(FiniteIterable<?> iterable) {
        boolean modified = false;
        FreezableIterator<E> iterator = this.freezableIterator();
        while (iterator.hasNext()) {
            if (iterable.contains(iterator.next())) continue;
            iterator.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    @Impure
    @NonFrozenRecipient
    default public boolean retainAll(@NonCaptured @Unmodified Collection<?> collection) {
        return this.retainAll(FiniteIterable.of(collection));
    }

    @Override
    @Impure
    @NonFrozenRecipient
    default public boolean retainAll(@NonCaptured @Unmodified FreezableCollection<?> collection) {
        return this.retainAll((FiniteIterable<?>)collection);
    }
}

