/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.collection;

import java.util.Collection;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.annotations.ownership.NonCaptured;
import net.digitalid.utility.annotations.ownership.Shared;
import net.digitalid.utility.annotations.parameter.Modified;
import net.digitalid.utility.annotations.parameter.Unmodified;
import net.digitalid.utility.collections.collection.BackedFreezableCollectionSubclass;
import net.digitalid.utility.collections.collection.FreezableCollection;
import net.digitalid.utility.collections.collection.ReadOnlyCollection;
import net.digitalid.utility.collections.iterator.FreezableIterator;
import net.digitalid.utility.collections.list.FreezableArrayList;
import net.digitalid.utility.freezable.FreezableInterface;
import net.digitalid.utility.freezable.annotations.Freezable;
import net.digitalid.utility.freezable.annotations.NonFrozen;
import net.digitalid.utility.freezable.annotations.NonFrozenRecipient;
import net.digitalid.utility.functional.iterators.ReadOnlyIterableIterator;
import net.digitalid.utility.functional.iterators.ReadOnlyIterator;
import net.digitalid.utility.generator.annotations.generators.GenerateSubclass;
import net.digitalid.utility.rootclass.RootClass;

@GenerateSubclass
@Freezable(value=ReadOnlyCollection.class)
public abstract class BackedFreezableCollection<E>
extends RootClass
implements FreezableCollection<E> {
    @Shared
    protected final FreezableInterface freezable;
    private final Collection<E> collection;

    protected BackedFreezableCollection(FreezableInterface freezable, Collection<E> collection) {
        this.freezable = freezable;
        this.collection = collection;
    }

    @Pure
    @Capturable
    public static <E> BackedFreezableCollection<E> with(@Shared @Modified FreezableInterface freezable, @Captured Collection<E> collection) {
        return new BackedFreezableCollectionSubclass<E>(freezable, collection);
    }

    @Pure
    public boolean isFrozen() {
        return this.freezable.isFrozen();
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public ReadOnlyCollection<E> freeze() {
        this.freezable.freeze();
        return this;
    }

    @Override
    @Pure
    @Capturable
    @NonFrozen
    public FreezableCollection<E> clone() {
        return FreezableArrayList.withElementsOf(this.collection);
    }

    @Override
    @Pure
    public int size() {
        return this.collection.size();
    }

    @Override
    @Pure
    @Capturable
    public ReadOnlyIterator<E> iterator() {
        return ReadOnlyIterableIterator.with(this.collection.iterator());
    }

    @Override
    @Pure
    @Capturable
    public FreezableIterator<E> freezableIterator() {
        return FreezableIterator.with(this.collection.iterator(), this);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean add(@Captured E element) {
        return this.collection.add(element);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean addAll(@NonCaptured @Unmodified Collection<? extends E> c) {
        return this.collection.addAll(c);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean remove(@NonCaptured @Unmodified Object object) {
        return this.collection.remove(object);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean removeAll(@NonCaptured @Unmodified Collection<?> c) {
        return this.collection.removeAll(c);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public boolean retainAll(@NonCaptured @Unmodified Collection<?> c) {
        return this.collection.retainAll(c);
    }

    @Override
    @Impure
    @NonFrozenRecipient
    public void clear() {
        this.collection.clear();
    }

    @Override
    @Pure
    public boolean equals(Object object) {
        return this.collection.equals(object);
    }

    @Override
    @Pure
    public int hashCode() {
        return this.collection.hashCode();
    }

    @Pure
    public String toString() {
        return this.collection.toString();
    }
}

