/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.collections.array;

import java.util.Arrays;
import java.util.Collection;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.NonCapturable;
import net.digitalid.utility.annotations.ownership.NonCaptured;
import net.digitalid.utility.annotations.parameter.Unmodified;
import net.digitalid.utility.circumfixes.Brackets;
import net.digitalid.utility.circumfixes.Circumfix;
import net.digitalid.utility.collections.array.FreezableArraySubclass;
import net.digitalid.utility.collections.array.ReadOnlyArray;
import net.digitalid.utility.collections.collection.FreezableCollection;
import net.digitalid.utility.collections.iterable.FreezableIterable;
import net.digitalid.utility.freezable.annotations.Freezable;
import net.digitalid.utility.freezable.annotations.NonFrozen;
import net.digitalid.utility.freezable.annotations.NonFrozenRecipient;
import net.digitalid.utility.functional.iterables.FiniteIterable;
import net.digitalid.utility.functional.iterators.ReadOnlyArrayIterator;
import net.digitalid.utility.generator.annotations.generators.GenerateSubclass;
import net.digitalid.utility.rootclass.RootClass;
import net.digitalid.utility.validation.annotations.index.Index;
import net.digitalid.utility.validation.annotations.math.NonNegative;
import net.digitalid.utility.validation.annotations.method.Chainable;

@GenerateSubclass
@Freezable(value=ReadOnlyArray.class)
public abstract class FreezableArray<E>
extends RootClass
implements ReadOnlyArray<E>,
FreezableIterable<E> {
    private final E[] elements;
    private boolean frozen = false;

    protected FreezableArray(@NonNegative int size) {
        this.elements = new Object[size];
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableArray<E> withSize(@NonNegative int size) {
        return new FreezableArraySubclass(size);
    }

    @SafeVarargs
    protected FreezableArray(E ... elements) {
        this.elements = (Object[])elements.clone();
    }

    @Pure
    @SafeVarargs
    @Capturable
    @NonFrozen
    public static <E> FreezableArray<E> withElements(E ... elements) {
        return elements == null ? null : new FreezableArraySubclass<E>(elements);
    }

    protected FreezableArray(@NonNegative int size, Iterable<? extends E> iterable) {
        this(size);
        int index = 0;
        for (E element : iterable) {
            this.elements[index++] = element;
        }
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableArray<E> withElementsOf(FiniteIterable<? extends E> iterable) {
        return iterable == null ? null : new FreezableArraySubclass<E>(iterable.size(), iterable);
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableArray<E> withElementsOf(@NonCaptured @Unmodified Collection<? extends E> collection) {
        return collection == null ? null : new FreezableArraySubclass<E>(collection.size(), collection);
    }

    @Pure
    @Capturable
    @NonFrozen
    public static <E> FreezableArray<E> withElementsOf(@NonCaptured @Unmodified FreezableCollection<? extends E> collection) {
        return collection == null ? null : new FreezableArraySubclass<E>(collection.size(), collection);
    }

    @Pure
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    @Impure
    @NonFrozenRecipient
    @Chainable
    public ReadOnlyArray<E> freeze() {
        this.frozen = true;
        return this;
    }

    @Pure
    @NonNegative
    public int size() {
        return this.elements.length;
    }

    @Pure
    public E get(@Index int index) {
        return this.elements[index];
    }

    @Override
    @Pure
    @Capturable
    public ReadOnlyArrayIterator<E> iterator() {
        return ReadOnlyArrayIterator.with((Object[])this.elements);
    }

    @Pure
    @NonCapturable
    public E getFirst(@NonCaptured @Unmodified E defaultElement) {
        return this.elements.length > 0 ? this.elements[0] : defaultElement;
    }

    @Pure
    @NonCapturable
    public E getLast(@NonCaptured @Unmodified E defaultElement) {
        return this.elements.length > 0 ? this.elements[this.elements.length - 1] : defaultElement;
    }

    @Impure
    @NonFrozenRecipient
    public void set(@Index int index, E element) {
        this.elements[index] = element;
    }

    @Impure
    @NonFrozenRecipient
    @Chainable
    @NonFrozen
    public FreezableArray<E> setAll(E element) {
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = element;
        }
        return this;
    }

    @Pure
    @Capturable
    public E[] toArray() {
        return (Object[])this.elements.clone();
    }

    @Override
    @Pure
    @Capturable
    @NonFrozen
    public FreezableArray<E> clone() {
        return new FreezableArraySubclass<Object>((Object[])this.elements.clone());
    }

    @Pure
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof FreezableArray) {
            return Arrays.equals(this.elements, ((FreezableArray)object).elements);
        }
        if (object instanceof Object[]) {
            return Arrays.equals(this.elements, (Object[])object);
        }
        return false;
    }

    @Pure
    public int hashCode() {
        return Arrays.deepHashCode(this.elements);
    }

    @Pure
    public String toString() {
        return this.join((Circumfix)Brackets.SQUARE);
    }
}

