package net.digitalid.utility.collections.set;

import javax.annotation.Generated;
import javax.annotation.Nonnull;

import net.digitalid.utility.validation.annotations.math.NonNegative;
import net.digitalid.utility.validation.annotations.math.Positive;
import net.digitalid.utility.validation.annotations.method.Chainable;

@SuppressWarnings("null")
@Generated(value = "net.digitalid.utility.processor.generator.JavaFileGenerator", date = "2017-03-26T11:54:22.112+0200")
public class FreezableLinkedHashSetBuilder<E> {
    
    public static class InnerFreezableLinkedHashSetBuilder<E> {
        
        private InnerFreezableLinkedHashSetBuilder() {
        }
        
        /* -------------------------------------------------- Initial Capacity -------------------------------------------------- */
        
        private @NonNegative int initialCapacity = 16;
        
        @Chainable
        public @Nonnull InnerFreezableLinkedHashSetBuilder<E> withInitialCapacity(@NonNegative int initialCapacity) {
            this.initialCapacity = initialCapacity;
            return this;
        }
        
        /* -------------------------------------------------- Load Factor -------------------------------------------------- */
        
        private @Positive float loadFactor = 0.75f;
        
        @Chainable
        public @Nonnull InnerFreezableLinkedHashSetBuilder<E> withLoadFactor(@Positive float loadFactor) {
            this.loadFactor = loadFactor;
            return this;
        }
        
        /* -------------------------------------------------- Build -------------------------------------------------- */
        
        public FreezableLinkedHashSet<E> build() {
            return new FreezableLinkedHashSetSubclass(initialCapacity, loadFactor);
        }
        
    }
    
    public static <E> InnerFreezableLinkedHashSetBuilder<E> withInitialCapacity(@NonNegative int initialCapacity) {
        return new InnerFreezableLinkedHashSetBuilder().withInitialCapacity(initialCapacity);
    }
    
    public static <E> InnerFreezableLinkedHashSetBuilder<E> withLoadFactor(@Positive float loadFactor) {
        return new InnerFreezableLinkedHashSetBuilder().withLoadFactor(loadFactor);
    }
    
    public static <E> FreezableLinkedHashSet<E> build() {
        return new InnerFreezableLinkedHashSetBuilder<E>().build();
    }
    
    public static <E> FreezableLinkedHashSet<E> buildWithInitialCapacity(@NonNegative int initialCapacity) {
        return new InnerFreezableLinkedHashSetBuilder<E>().withInitialCapacity(initialCapacity).build();
    }
    
    public static <E> FreezableLinkedHashSet<E> buildWithLoadFactor(@Positive float loadFactor) {
        return new InnerFreezableLinkedHashSetBuilder<E>().withLoadFactor(loadFactor).build();
    }
    
}
