package net.digitalid.utility.collections.set;

import javax.annotation.Generated;
import javax.annotation.Nonnull;

import net.digitalid.utility.validation.annotations.math.NonNegative;
import net.digitalid.utility.validation.annotations.math.Positive;
import net.digitalid.utility.validation.annotations.method.Chainable;

@SuppressWarnings("null")
@Generated(value = "net.digitalid.utility.processor.generator.JavaFileGenerator", date = "2017-03-26T11:54:22.258+0200")
public class FreezableHashSetBuilder<E> {
    
    public static class InnerFreezableHashSetBuilder<E> {
        
        private InnerFreezableHashSetBuilder() {
        }
        
        /* -------------------------------------------------- Initial Capacity -------------------------------------------------- */
        
        private @NonNegative int initialCapacity = 16;
        
        @Chainable
        public @Nonnull InnerFreezableHashSetBuilder<E> withInitialCapacity(@NonNegative int initialCapacity) {
            this.initialCapacity = initialCapacity;
            return this;
        }
        
        /* -------------------------------------------------- Load Factor -------------------------------------------------- */
        
        private @Positive float loadFactor = 0.75f;
        
        @Chainable
        public @Nonnull InnerFreezableHashSetBuilder<E> withLoadFactor(@Positive float loadFactor) {
            this.loadFactor = loadFactor;
            return this;
        }
        
        /* -------------------------------------------------- Build -------------------------------------------------- */
        
        public FreezableHashSet<E> build() {
            return new FreezableHashSetSubclass(initialCapacity, loadFactor);
        }
        
    }
    
    public static <E> InnerFreezableHashSetBuilder<E> withInitialCapacity(@NonNegative int initialCapacity) {
        return new InnerFreezableHashSetBuilder().withInitialCapacity(initialCapacity);
    }
    
    public static <E> InnerFreezableHashSetBuilder<E> withLoadFactor(@Positive float loadFactor) {
        return new InnerFreezableHashSetBuilder().withLoadFactor(loadFactor);
    }
    
    public static <E> FreezableHashSet<E> build() {
        return new InnerFreezableHashSetBuilder<E>().build();
    }
    
    public static <E> FreezableHashSet<E> buildWithInitialCapacity(@NonNegative int initialCapacity) {
        return new InnerFreezableHashSetBuilder<E>().withInitialCapacity(initialCapacity).build();
    }
    
    public static <E> FreezableHashSet<E> buildWithLoadFactor(@Positive float loadFactor) {
        return new InnerFreezableHashSetBuilder<E>().withLoadFactor(loadFactor).build();
    }
    
}
