package net.digitalid.utility.collections.map;

import javax.annotation.Generated;
import javax.annotation.Nonnull;

import net.digitalid.utility.validation.annotations.math.NonNegative;
import net.digitalid.utility.validation.annotations.math.Positive;
import net.digitalid.utility.validation.annotations.method.Chainable;

@SuppressWarnings("null")
@Generated(value = "net.digitalid.utility.processor.generator.JavaFileGenerator", date = "2017-03-26T11:54:21.284+0200")
public class FreezableLinkedHashMapBuilder<K, V> {
    
    public static class InnerFreezableLinkedHashMapBuilder<K, V> {
        
        private InnerFreezableLinkedHashMapBuilder() {
        }
        
        /* -------------------------------------------------- Initial Capacity -------------------------------------------------- */
        
        private @NonNegative int initialCapacity = 16;
        
        @Chainable
        public @Nonnull InnerFreezableLinkedHashMapBuilder<K, V> withInitialCapacity(@NonNegative int initialCapacity) {
            this.initialCapacity = initialCapacity;
            return this;
        }
        
        /* -------------------------------------------------- Load Factor -------------------------------------------------- */
        
        private @Positive float loadFactor = 0.75f;
        
        @Chainable
        public @Nonnull InnerFreezableLinkedHashMapBuilder<K, V> withLoadFactor(@Positive float loadFactor) {
            this.loadFactor = loadFactor;
            return this;
        }
        
        /* -------------------------------------------------- Access Order -------------------------------------------------- */
        
        private boolean accessOrder = false;
        
        @Chainable
        public @Nonnull InnerFreezableLinkedHashMapBuilder<K, V> withAccessOrder(boolean accessOrder) {
            this.accessOrder = accessOrder;
            return this;
        }
        
        /* -------------------------------------------------- Build -------------------------------------------------- */
        
        public FreezableLinkedHashMap<K, V> build() {
            return new FreezableLinkedHashMapSubclass(initialCapacity, loadFactor, accessOrder);
        }
        
    }
    
    public static <K, V> InnerFreezableLinkedHashMapBuilder<K, V> withInitialCapacity(@NonNegative int initialCapacity) {
        return new InnerFreezableLinkedHashMapBuilder().withInitialCapacity(initialCapacity);
    }
    
    public static <K, V> InnerFreezableLinkedHashMapBuilder<K, V> withLoadFactor(@Positive float loadFactor) {
        return new InnerFreezableLinkedHashMapBuilder().withLoadFactor(loadFactor);
    }
    
    public static <K, V> InnerFreezableLinkedHashMapBuilder<K, V> withAccessOrder(boolean accessOrder) {
        return new InnerFreezableLinkedHashMapBuilder().withAccessOrder(accessOrder);
    }
    
    public static <K, V> FreezableLinkedHashMap<K, V> build() {
        return new InnerFreezableLinkedHashMapBuilder<K, V>().build();
    }
    
    public static <K, V> FreezableLinkedHashMap<K, V> buildWithInitialCapacity(@NonNegative int initialCapacity) {
        return new InnerFreezableLinkedHashMapBuilder<K, V>().withInitialCapacity(initialCapacity).build();
    }
    
    public static <K, V> FreezableLinkedHashMap<K, V> buildWithLoadFactor(@Positive float loadFactor) {
        return new InnerFreezableLinkedHashMapBuilder<K, V>().withLoadFactor(loadFactor).build();
    }
    
    public static <K, V> FreezableLinkedHashMap<K, V> buildWithAccessOrder(boolean accessOrder) {
        return new InnerFreezableLinkedHashMapBuilder<K, V>().withAccessOrder(accessOrder).build();
    }
    
}
