package net.digitalid.utility.collections.map;

import javax.annotation.Generated;
import javax.annotation.Nonnull;

import net.digitalid.utility.validation.annotations.math.NonNegative;
import net.digitalid.utility.validation.annotations.math.Positive;
import net.digitalid.utility.validation.annotations.method.Chainable;

@SuppressWarnings("null")
@Generated(value = "net.digitalid.utility.processor.generator.JavaFileGenerator", date = "2017-03-26T11:54:20.990+0200")
public class FreezableHashMapBuilder<K, V> {
    
    public static class InnerFreezableHashMapBuilder<K, V> {
        
        private InnerFreezableHashMapBuilder() {
        }
        
        /* -------------------------------------------------- Initial Capacity -------------------------------------------------- */
        
        private @NonNegative int initialCapacity = 16;
        
        @Chainable
        public @Nonnull InnerFreezableHashMapBuilder<K, V> withInitialCapacity(@NonNegative int initialCapacity) {
            this.initialCapacity = initialCapacity;
            return this;
        }
        
        /* -------------------------------------------------- Load Factor -------------------------------------------------- */
        
        private @Positive float loadFactor = 0.75f;
        
        @Chainable
        public @Nonnull InnerFreezableHashMapBuilder<K, V> withLoadFactor(@Positive float loadFactor) {
            this.loadFactor = loadFactor;
            return this;
        }
        
        /* -------------------------------------------------- Build -------------------------------------------------- */
        
        public FreezableHashMap<K, V> build() {
            return new FreezableHashMapSubclass(initialCapacity, loadFactor);
        }
        
    }
    
    public static <K, V> InnerFreezableHashMapBuilder<K, V> withInitialCapacity(@NonNegative int initialCapacity) {
        return new InnerFreezableHashMapBuilder().withInitialCapacity(initialCapacity);
    }
    
    public static <K, V> InnerFreezableHashMapBuilder<K, V> withLoadFactor(@Positive float loadFactor) {
        return new InnerFreezableHashMapBuilder().withLoadFactor(loadFactor);
    }
    
    public static <K, V> FreezableHashMap<K, V> build() {
        return new InnerFreezableHashMapBuilder<K, V>().build();
    }
    
    public static <K, V> FreezableHashMap<K, V> buildWithInitialCapacity(@NonNegative int initialCapacity) {
        return new InnerFreezableHashMapBuilder<K, V>().withInitialCapacity(initialCapacity).build();
    }
    
    public static <K, V> FreezableHashMap<K, V> buildWithLoadFactor(@Positive float loadFactor) {
        return new InnerFreezableHashMapBuilder<K, V>().withLoadFactor(loadFactor).build();
    }
    
}
