package net.digitalid.utility.collections.list;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.Generated;
import javax.annotation.Nonnull;

import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.NonCaptured;
import net.digitalid.utility.annotations.parameter.Modified;
import net.digitalid.utility.annotations.parameter.Unmodified;
import net.digitalid.utility.conversion.enumerations.Representation;
import net.digitalid.utility.conversion.exceptions.ConnectionException;
import net.digitalid.utility.conversion.exceptions.RecoveryException;
import net.digitalid.utility.conversion.interfaces.Converter;
import net.digitalid.utility.conversion.interfaces.Decoder;
import net.digitalid.utility.conversion.interfaces.Encoder;
import net.digitalid.utility.conversion.model.CustomAnnotation;
import net.digitalid.utility.conversion.model.CustomField;
import net.digitalid.utility.immutable.ImmutableList;
import net.digitalid.utility.immutable.ImmutableMap;

import static net.digitalid.utility.conversion.model.CustomType.BOOLEAN;

@SuppressWarnings("null")
@Generated(value = "net.digitalid.utility.processor.generator.JavaFileGenerator", date = "2017-03-26T11:54:22.159+0200")
public class ReadOnlyListConverter<E> implements Converter<ReadOnlyList, Void> {
    
    public static final @Nonnull ReadOnlyListConverter INSTANCE = new ReadOnlyListConverter();
    
    @Pure
    @Override
    public @Nonnull Class<ReadOnlyList> getType() {
        return ReadOnlyList.class;
    }
    
    @Pure
    @Override
    public @Nonnull String getTypeName() {
        return "ReadOnlyList";
    }
    
    @Pure
    @Override
    public @Nonnull String getTypePackage() {
        return "net.digitalid.utility.collections.list";
    }
    
    private static final @Nonnull ImmutableList<CustomField> fields;
    
    static {
        final @Nonnull Map<String, Object> frozenPure = new HashMap<>();
        
        fields = ImmutableList.withElements(CustomField.with(BOOLEAN, "frozen", ImmutableList.<CustomAnnotation>withElements(CustomAnnotation.with(Pure.class, ImmutableMap.withMappingsOf(frozenPure)))));
    }
    
    @Pure
    @Override
    public @Nonnull ImmutableList< CustomField> getFields(@Nonnull Representation representation) {
        return fields;
    }
    
    @Pure
    @Override
    public <EXCEPTION extends ConnectionException> void convert(@NonCaptured @Unmodified @Nonnull ReadOnlyList readOnlyList, @Nonnull @NonCaptured @Modified Encoder<EXCEPTION> encoder) throws EXCEPTION {
        encoder.encodeBoolean(readOnlyList.isFrozen());
    }
    
    @Pure
    @Override
    public @Capturable @Nonnull <EXCEPTION extends ConnectionException> ReadOnlyList recover(@Nonnull @NonCaptured Decoder<EXCEPTION> decoder, Void none) throws EXCEPTION, RecoveryException {
        final boolean frozen = decoder.decodeBoolean();
        return ReadOnlyList.with(frozen);
    }
    
}
