package net.digitalid.utility.collections.array;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Generated;
import javax.annotation.Nonnull;

import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.circumfixes.Circumfix;
import net.digitalid.utility.collections.collection.FreezableCollection;
import net.digitalid.utility.collections.list.FreezableList;
import net.digitalid.utility.collections.map.FreezableMap;
import net.digitalid.utility.collections.set.FreezableSet;
import net.digitalid.utility.contracts.Ensure;
import net.digitalid.utility.contracts.Require;
import net.digitalid.utility.functional.failable.FailableBinaryOperator;
import net.digitalid.utility.functional.failable.FailableCollector;
import net.digitalid.utility.functional.failable.FailableConsumer;
import net.digitalid.utility.functional.failable.FailablePredicate;
import net.digitalid.utility.functional.failable.FailableUnaryFunction;
import net.digitalid.utility.functional.iterables.FiniteIterable;
import net.digitalid.utility.functional.iterables.InfiniteIterable;
import net.digitalid.utility.functional.iterators.ReadOnlyArrayIterator;
import net.digitalid.utility.tuples.Pair;
import net.digitalid.utility.validation.annotations.math.NonNegative;

@SuppressWarnings("null")
@Generated(value = "net.digitalid.utility.processor.generator.JavaFileGenerator", date = "2017-03-26T11:54:21.176+0200")
class FreezableArraySubclass<E> extends FreezableArray<E> {
    
    /* -------------------------------------------------- Constructors -------------------------------------------------- */
    
    FreezableArraySubclass(@NonNegative int size) throws RuntimeException {
        super(size);
        
        initialize();
        validate();
    }
    
    FreezableArraySubclass(E[] elements) throws RuntimeException {
        super(elements);
        
        initialize();
        validate();
    }
    
    FreezableArraySubclass(@NonNegative int size, @Nonnull Iterable<? extends E> iterable) throws RuntimeException {
        super(size, iterable);
        
        initialize();
        validate();
    }
    
    /* -------------------------------------------------- Overridden Methods -------------------------------------------------- */
    
    @Override
    public <T> T castTo(Class<T> targetClass) {
        T result = super.castTo(targetClass);
        Ensure.that(result == this).orThrow("The result has to be <this> but was $.", result);
        return result;
    }
    
    @Override
    public boolean hasSize(int arg0) {
        Require.that(arg0 >= 0).orThrow("The arg0 has to be non-negative but was $.", arg0);
        boolean result = super.hasSize(arg0);
        return result;
    }
    
    @Override
    public boolean sizeAtMost(int arg0) {
        Require.that(arg0 >= 0).orThrow("The arg0 has to be non-negative but was $.", arg0);
        boolean result = super.sizeAtMost(arg0);
        return result;
    }
    
    @Override
    public boolean sizeAtLeast(int arg0) {
        Require.that(arg0 > 0).orThrow("The arg0 has to be positive but was $.", arg0);
        boolean result = super.sizeAtLeast(arg0);
        return result;
    }
    
    @Override
    public FiniteIterable<E> limit(int arg0) {
        Require.that(arg0 > 0).orThrow("The arg0 has to be positive but was $.", arg0);
        FiniteIterable<E> result = super.limit(arg0);
        return result;
    }
    
    @Override
    public FiniteIterable<E> extract(int arg0, int arg1) {
        Require.that(arg0 > 0).orThrow("The arg0 has to be positive but was $.", arg0);
        Require.that(arg1 > 0).orThrow("The arg1 has to be positive but was $.", arg1);
        FiniteIterable<E> result = super.extract(arg0, arg1);
        return result;
    }
    
    @Override
    public <TYPE> FiniteIterable<Pair<E, TYPE>> zipShortest(FiniteIterable<? extends TYPE> iterable) {
        FiniteIterable<Pair<E, TYPE>> result = super.zipShortest(iterable);
        return result;
    }
    
    @Override
    public <TYPE> InfiniteIterable<Pair<E, TYPE>> zipLongest(InfiniteIterable<? extends TYPE> iterable) {
        InfiniteIterable<Pair<E, TYPE>> result = super.zipLongest(iterable);
        return result;
    }
    
    @Override
    public boolean isSingle() {
        boolean result = super.isSingle();
        return result;
    }
    
    @Override
    public boolean isEmptyOrSingle() {
        boolean result = super.isEmptyOrSingle();
        return result;
    }
    
    @Override
    public FiniteIterable<E> filter(FailablePredicate<? super E, ?> predicate) {
        FiniteIterable<E> result = super.filter(predicate);
        return result;
    }
    
    @Override
    public FiniteIterable<E> filterNot(FailablePredicate<? super E, ?> predicate) {
        FiniteIterable<E> result = super.filterNot(predicate);
        return result;
    }
    
    @Override
    public FiniteIterable<E> filterNulls() {
        FiniteIterable<E> result = super.filterNulls();
        return result;
    }
    
    @Override
    public <TYPE> FiniteIterable<TYPE> map(FailableUnaryFunction<? super E, ? extends TYPE, ?> function) {
        FiniteIterable<TYPE> result = super.map(function);
        return result;
    }
    
    @Override
    public <TYPE> FiniteIterable<TYPE> instanceOf(Class<TYPE> type) {
        FiniteIterable<TYPE> result = super.instanceOf(type);
        return result;
    }
    
    @Override
    public FiniteIterable<E> skip(int arg0) {
        Require.that(arg0 > 0).orThrow("The arg0 has to be positive but was $.", arg0);
        FiniteIterable<E> result = super.skip(arg0);
        return result;
    }
    
    @Override
    public <TYPE> FiniteIterable<Pair<E, TYPE>> zipShortest(InfiniteIterable<? extends TYPE> iterable) {
        FiniteIterable<Pair<E, TYPE>> result = super.zipShortest(iterable);
        return result;
    }
    
    @Override
    public <TYPE> FiniteIterable<Pair<E, TYPE>> zipLongest(FiniteIterable<? extends TYPE> iterable) {
        FiniteIterable<Pair<E, TYPE>> result = super.zipLongest(iterable);
        return result;
    }
    
    @Override
    public <TYPE> FiniteIterable<TYPE> flatten(int arg0) {
        Require.that(arg0 > 0).orThrow("The arg0 has to be positive but was $.", arg0);
        FiniteIterable<TYPE> result = super.flatten(arg0);
        return result;
    }
    
    @Override
    public <TYPE> FiniteIterable<TYPE> flattenOne() {
        FiniteIterable<TYPE> result = super.flattenOne();
        return result;
    }
    
    @Override
    public <TYPE> FiniteIterable<TYPE> flattenAll() {
        FiniteIterable<TYPE> result = super.flattenAll();
        return result;
    }
    
    @Override
    public boolean equals(FiniteIterable<?> iterable) {
        boolean result = super.equals(iterable);
        return result;
    }
    
    @Override
    public E getFirstOrNull() {
        E result = super.getFirstOrNull();
        return result;
    }
    
    @Override
    public E getFirst() {
        E result = super.getFirst();
        return result;
    }
    
    @Override
    public E getLastOrNull() {
        E result = super.getLastOrNull();
        return result;
    }
    
    @Override
    public E getLast() {
        E result = super.getLast();
        return result;
    }
    
    @Override
    public int indexOf(Object arg0) {
        int result = super.indexOf(arg0);
        Ensure.that(result >= -1l).orThrow("The result has to be greater than or equal to -1l but was $.", result);
        return result;
    }
    
    @Override
    public int lastIndexOf(Object arg0) {
        int result = super.lastIndexOf(arg0);
        Ensure.that(result >= -1l).orThrow("The result has to be greater than or equal to -1l but was $.", result);
        return result;
    }
    
    @Override
    public int count(Object arg0) {
        int result = super.count(arg0);
        Ensure.that(result >= 0).orThrow("The result has to be non-negative but was $.", result);
        return result;
    }
    
    @Override
    public boolean contains(Object arg0) {
        boolean result = super.contains(arg0);
        return result;
    }
    
    @Override
    public boolean containsAll(FiniteIterable<?> iterable) {
        boolean result = super.containsAll(iterable);
        return result;
    }
    
    @Override
    public boolean containsAll(Collection<?> arg0) {
        boolean result = super.containsAll(arg0);
        return result;
    }
    
    @Override
    public boolean containsNull() {
        boolean result = super.containsNull();
        return result;
    }
    
    @Override
    public boolean containsDuplicates() {
        boolean result = super.containsDuplicates();
        return result;
    }
    
    @Override
    public FiniteIterable<E> distinct() {
        FiniteIterable<E> result = super.distinct();
        return result;
    }
    
    @Override
    public <EXCEPTION extends Exception> FiniteIterable<E> doForEach(FailableConsumer<? super E, ? extends EXCEPTION> arg0) throws EXCEPTION {
        FiniteIterable<E> result = super.doForEach(arg0);
        Ensure.that(result == this).orThrow("The result has to be <this> but was $.", result);
        return result;
    }
    
    @Override
    public FiniteIterable<E> intersect(FiniteIterable<? super E> iterable) {
        FiniteIterable<E> result = super.intersect(iterable);
        return result;
    }
    
    @Override
    public FiniteIterable<E> exclude(FiniteIterable<? super E> iterable) {
        FiniteIterable<E> result = super.exclude(iterable);
        return result;
    }
    
    @Override
    public FiniteIterable<E> combine(FiniteIterable<? extends E> iterable) {
        FiniteIterable<E> result = super.combine(iterable);
        return result;
    }
    
    @Override
    public InfiniteIterable<E> combine(InfiniteIterable<? extends E> iterable) {
        InfiniteIterable<E> result = super.combine(iterable);
        return result;
    }
    
    @Override
    public InfiniteIterable<E> repeated() {
        InfiniteIterable<E> result = super.repeated();
        return result;
    }
    
    @Override
    public <EXCEPTION extends Exception> E findFirst(FailablePredicate<? super E, ? extends EXCEPTION> arg0, E arg1) throws EXCEPTION {
        E result = super.findFirst(arg0, arg1);
        return result;
    }
    
    @Override
    public <EXCEPTION extends Exception> E findFirst(FailablePredicate<? super E, ? extends EXCEPTION> predicate) throws EXCEPTION {
        E result = super.findFirst(predicate);
        return result;
    }
    
    @Override
    public <EXCEPTION extends Exception> E findLast(FailablePredicate<? super E, ? extends EXCEPTION> arg0, E arg1) throws EXCEPTION {
        E result = super.findLast(arg0, arg1);
        return result;
    }
    
    @Override
    public <EXCEPTION extends Exception> E findLast(FailablePredicate<? super E, ? extends EXCEPTION> predicate) throws EXCEPTION {
        E result = super.findLast(predicate);
        return result;
    }
    
    @Override
    public <EXCEPTION extends Exception> E findUnique(FailablePredicate<? super E, ? extends EXCEPTION> predicate) throws EXCEPTION {
        E result = super.findUnique(predicate);
        return result;
    }
    
    @Override
    public <EXCEPTION extends Exception> boolean matchAny(FailablePredicate<? super E, ? extends EXCEPTION> predicate) throws EXCEPTION {
        boolean result = super.matchAny(predicate);
        return result;
    }
    
    @Override
    public <EXCEPTION extends Exception> boolean matchAll(FailablePredicate<? super E, ? extends EXCEPTION> predicate) throws EXCEPTION {
        boolean result = super.matchAll(predicate);
        return result;
    }
    
    @Override
    public <EXCEPTION extends Exception> boolean matchNone(FailablePredicate<? super E, ? extends EXCEPTION> predicate) throws EXCEPTION {
        boolean result = super.matchNone(predicate);
        return result;
    }
    
    @Override
    public <EXCEPTION extends Exception> E reduce(FailableBinaryOperator<E, ? extends EXCEPTION> arg0, E arg1) throws EXCEPTION {
        E result = super.reduce(arg0, arg1);
        return result;
    }
    
    @Override
    public <EXCEPTION extends Exception> E reduce(FailableBinaryOperator<E, ? extends EXCEPTION> operator) throws EXCEPTION {
        E result = super.reduce(operator);
        return result;
    }
    
    @Override
    public <RESULT, COLLECT_EXCEPTION extends Exception, RESULT_EXCEPTION extends Exception> RESULT collect(FailableCollector<? super E, ? extends RESULT, ? extends COLLECT_EXCEPTION, ? extends RESULT_EXCEPTION> arg0) throws COLLECT_EXCEPTION, RESULT_EXCEPTION {
        RESULT result = super.collect(arg0);
        return result;
    }
    
    @Override
    public boolean isOrdered(boolean strictly, boolean ascending) {
        boolean result = super.isOrdered(strictly, ascending);
        return result;
    }
    
    @Override
    public boolean isAscending() {
        boolean result = super.isAscending();
        return result;
    }
    
    @Override
    public boolean isStrictlyAscending() {
        boolean result = super.isStrictlyAscending();
        return result;
    }
    
    @Override
    public boolean isDescending() {
        boolean result = super.isDescending();
        return result;
    }
    
    @Override
    public boolean isStrictlyDescending() {
        boolean result = super.isStrictlyDescending();
        return result;
    }
    
    @Override
    public FiniteIterable<E> sorted(Comparator<? super E> comparator) {
        FiniteIterable<E> result = super.sorted(comparator);
        return result;
    }
    
    @Override
    public FiniteIterable<E> sorted() {
        FiniteIterable<E> result = super.sorted();
        return result;
    }
    
    @Override
    public FiniteIterable<E> reversed() {
        FiniteIterable<E> result = super.reversed();
        return result;
    }
    
    @Override
    public E min(Comparator<? super E> arg0, E arg1) {
        E result = super.min(arg0, arg1);
        return result;
    }
    
    @Override
    public E min(Comparator<? super E> comparator) {
        E result = super.min(comparator);
        return result;
    }
    
    @Override
    public E min(E arg0) {
        E result = super.min(arg0);
        return result;
    }
    
    @Override
    public E min() {
        E result = super.min();
        return result;
    }
    
    @Override
    public E max(Comparator<? super E> arg0, E arg1) {
        E result = super.max(arg0, arg1);
        return result;
    }
    
    @Override
    public E max(Comparator<? super E> comparator) {
        E result = super.max(comparator);
        return result;
    }
    
    @Override
    public E max(E arg0) {
        E result = super.max(arg0);
        return result;
    }
    
    @Override
    public E max() {
        E result = super.max();
        return result;
    }
    
    @Override
    public long sumAsLong() {
        long result = super.sumAsLong();
        return result;
    }
    
    @Override
    public double sumAsDouble() {
        double result = super.sumAsDouble();
        return result;
    }
    
    @Override
    public double average() {
        double result = super.average();
        return result;
    }
    
    @Override
    public String join(CharSequence prefix, CharSequence suffix, CharSequence empty, CharSequence delimiter) {
        String result = super.join(prefix, suffix, empty, delimiter);
        return result;
    }
    
    @Override
    public String join(CharSequence prefix, CharSequence suffix, CharSequence empty) {
        String result = super.join(prefix, suffix, empty);
        return result;
    }
    
    @Override
    public String join(CharSequence prefix, CharSequence suffix) {
        String result = super.join(prefix, suffix);
        return result;
    }
    
    @Override
    public String join(Circumfix fixes, CharSequence empty, CharSequence delimiter) {
        String result = super.join(fixes, empty, delimiter);
        return result;
    }
    
    @Override
    public String join(Circumfix fixes, CharSequence empty) {
        String result = super.join(fixes, empty);
        return result;
    }
    
    @Override
    public String join(Circumfix fixes) {
        String result = super.join(fixes);
        return result;
    }
    
    @Override
    public String join(CharSequence delimiter) {
        String result = super.join(delimiter);
        return result;
    }
    
    @Override
    public String join() {
        String result = super.join();
        return result;
    }
    
    @Override
    public E[] toGenericArray() {
        E[] result = super.toGenericArray();
        return result;
    }
    
    @Override
    public <TYPE> TYPE[] toArray(TYPE[] arg0) {
        TYPE[] result = super.toArray(arg0);
        return result;
    }
    
    @Override
    public List<E> toList() {
        List<E> result = super.toList();
        return result;
    }
    
    @Override
    public Set<E> toSet() {
        Set<E> result = super.toSet();
        return result;
    }
    
    @Override
    public <KEY, EXCEPTION extends Exception> Map<KEY, E> toMap(FailableUnaryFunction<? super E, ? extends KEY, ? extends EXCEPTION> function) throws EXCEPTION {
        Map<KEY, E> result = super.toMap(function);
        return result;
    }
    
    @Override
    public <KEY, EXCEPTION extends Exception> Map<KEY, List<E>> groupBy(FailableUnaryFunction<? super E, ? extends KEY, ? extends EXCEPTION> function) throws EXCEPTION {
        Map<KEY, List<E>> result = super.groupBy(function);
        return result;
    }
    
    @Override
    public <EXCEPTION extends Exception> FiniteIterable<E> evaluate() throws EXCEPTION {
        FiniteIterable<E> result = super.evaluate();
        return result;
    }
    
    @Override
    protected void initialize() throws RuntimeException {
        super.initialize();
    }
    
    @Override
    public boolean isEmpty() {
        boolean result = super.isEmpty();
        return result;
    }
    
    @Override
    public int size(int arg0) {
        Require.that(arg0 > 0).orThrow("The arg0 has to be positive but was $.", arg0);
        int result = super.size(arg0);
        Ensure.that(result >= 0).orThrow("The result has to be non-negative but was $.", result);
        return result;
    }
    
    @Override
    public FreezableArray<E> toFreezableArray() {
        FreezableArray<E> result = super.toFreezableArray();
        Ensure.that(result != null).orThrow("The result may not be null.", result);
        Ensure.that(result == null || !result.isFrozen()).orThrow("The result has to be null or may not be frozen.", result);
        return result;
    }
    
    @Override
    public FreezableList<E> toFreezableList() {
        FreezableList<E> result = super.toFreezableList();
        Ensure.that(result != null).orThrow("The result may not be null.", result);
        Ensure.that(result == null || !result.isFrozen()).orThrow("The result has to be null or may not be frozen.", result);
        return result;
    }
    
    @Override
    public FreezableSet<E> toFreezableSet() {
        FreezableSet<E> result = super.toFreezableSet();
        Ensure.that(result != null).orThrow("The result may not be null.", result);
        Ensure.that(result == null || !result.isFrozen()).orThrow("The result has to be null or may not be frozen.", result);
        return result;
    }
    
    @Override
    public <KEY, EXCEPTION extends Exception> FreezableMap<KEY, E> toFreezableMap(FailableUnaryFunction<? super E, ? extends KEY, ? extends EXCEPTION> function) throws EXCEPTION {
        Require.that(function != null).orThrow("The function may not be null.", function);
        FreezableMap<KEY, E> result = super.toFreezableMap(function);
        Ensure.that(result != null).orThrow("The result may not be null.", result);
        Ensure.that(result == null || !result.isFrozen()).orThrow("The result has to be null or may not be frozen.", result);
        return result;
    }
    
    @Override
    public boolean containsAll(FreezableCollection<?> collection) {
        Require.that(collection != null).orThrow("The collection may not be null.", collection);
        boolean result = super.containsAll(collection);
        return result;
    }
    
    @Override
    public boolean isFrozen() {
        boolean result = super.isFrozen();
        return result;
    }
    
    @Override
    public ReadOnlyArray<E> freeze() {
        Require.that(!isFrozen()).orThrow("The method 'freeze' may only be called on non-frozen objects.");
        ReadOnlyArray<E> result = super.freeze();
        Ensure.that(result == this).orThrow("The result has to be <this> but was $.", result);
        Ensure.that(result != null).orThrow("The result may not be null.", result);
        Ensure.that(result == null || result.isFrozen()).orThrow("The result has to be null or frozen.", result);
        return result;
    }
    
    @Override
    public int size() {
        int result = super.size();
        Ensure.that(result >= 0).orThrow("The result has to be non-negative but was $.", result);
        return result;
    }
    
    @Override
    public E get(int index) {
        Require.that(index >= 0 && index < size()).orThrow("The index may not be negative or greater than or equal to the size of this collection but was $.", index);
        E result = super.get(index);
        return result;
    }
    
    @Override
    public ReadOnlyArrayIterator<E> iterator() {
        ReadOnlyArrayIterator<E> result = super.iterator();
        Ensure.that(result != null).orThrow("The result may not be null.", result);
        return result;
    }
    
    @Override
    public E getFirst(E defaultElement) {
        E result = super.getFirst(defaultElement);
        return result;
    }
    
    @Override
    public E getLast(E defaultElement) {
        E result = super.getLast(defaultElement);
        return result;
    }
    
    @Override
    public void set(int index, E element) {
        Require.that(index >= 0 && index < size()).orThrow("The index may not be negative or greater than or equal to the size of this collection but was $.", index);
        Require.that(!isFrozen()).orThrow("The method 'set' may only be called on non-frozen objects.");
        super.set(index, element);
    }
    
    @Override
    public FreezableArray<E> setAll(E element) {
        Require.that(!isFrozen()).orThrow("The method 'setAll' may only be called on non-frozen objects.");
        FreezableArray<E> result = super.setAll(element);
        Ensure.that(result == this).orThrow("The result has to be <this> but was $.", result);
        Ensure.that(result != null).orThrow("The result may not be null.", result);
        Ensure.that(result == null || !result.isFrozen()).orThrow("The result has to be null or may not be frozen.", result);
        return result;
    }
    
    @Override
    public E[] toArray() {
        E[] result = super.toArray();
        Ensure.that(result != null).orThrow("The result may not be null.", result);
        return result;
    }
    
    /* -------------------------------------------------- Implement Methods -------------------------------------------------- */
    
    /* -------------------------------------------------- Generated Methods -------------------------------------------------- */
    
    @Pure
    @Override
    public void validate() {
        super.validate();
    }
    
}
