/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.mapper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.di2e.ecdr.search.transform.mapper.TransformIdMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformIdMapperImpl
implements TransformIdMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformIdMapperImpl.class);
    private Map<String, String> queryTransformFormats = new HashMap<String, String>();
    private Map<String, String> metacardTransformFormats = new HashMap<String, String>();

    public TransformIdMapperImpl() {
        this.queryTransformFormats.put("atom", "cdr-atom");
        this.queryTransformFormats.put("ddf-atom", "atom");
        this.queryTransformFormats.put("atom-ddms", "atom-with-payload");
        this.queryTransformFormats.put("atom-ddms-2.0", "atom-with-payload");
        this.queryTransformFormats.put("atom-ddms-4.1", "atom-with-payload");
        this.queryTransformFormats.put("atom-ddms-5.0", "atom-with-payload");
        this.metacardTransformFormats.put("atom-ddms-2.0", "ddms20");
        this.metacardTransformFormats.put("atom-ddms-4.1", "ddms41");
        this.metacardTransformFormats.put("atom-ddms-5.0", "ddms50");
    }

    @Override
    public String getQueryResponseTransformValue(String value) {
        String xformValue = this.getValue(this.queryTransformFormats, value, false);
        LOGGER.debug("Returning the QueryResponseTransformer name [{}] for original value [{}]", (Object)xformValue, (Object)value);
        return xformValue;
    }

    public void setQueryResponseTransformValues(List<String> values) {
        this.queryTransformFormats.clear();
        LOGGER.debug("Updating the CDR QueryResponseTransformer value mapper to [{}]", values);
        this.setValues(values, this.queryTransformFormats);
    }

    @Override
    public String getMetacardTransformValue(String value) {
        String xformValue = this.getValue(this.metacardTransformFormats, value, true);
        LOGGER.debug("Returning the MetacardTransformer name [{}] for original value [{}]", (Object)xformValue, (Object)value);
        return xformValue;
    }

    public void setMetacardTransformValues(List<String> values) {
        this.metacardTransformFormats.clear();
        LOGGER.debug("Updating the CDR MetacardTransformer value mapper to [{}]", values);
        this.setValues(values, this.metacardTransformFormats);
    }

    protected String getValue(Map<String, String> valueMap, String value, boolean allowNull) {
        String mappedValue = null;
        if (value != null && valueMap.containsKey(value)) {
            mappedValue = valueMap.get(value);
        } else if (!allowNull) {
            mappedValue = value;
        }
        return mappedValue;
    }

    protected void setValues(List<String> values, Map<String, String> valueMap) {
        if (values != null) {
            for (String value : values) {
                String[] valueArray = value.split("=");
                if (valueArray.length == 2) {
                    valueMap.put(valueArray[0], valueArray[1]);
                    LOGGER.debug("Adding Transformer map name[{}] value[{}]", (Object)valueArray[0], (Object)valueArray[1]);
                    continue;
                }
                LOGGER.warn("Could not set the CDR Transformer Mapped Values because it was an invalid format, must be in the format [name=value] and was [{}]", (Object)value);
            }
        }
    }
}

