/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.geo.formatter;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LinearRing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.di2e.ecdr.search.transform.geo.formatter.CompositeGeometry;
import net.di2e.ecdr.search.transform.geo.formatter.MultiPoint;
import org.apache.abdera.ext.geo.Box;
import org.apache.abdera.ext.geo.Coordinate;
import org.apache.abdera.ext.geo.Coordinates;
import org.apache.abdera.ext.geo.Position;

public class Polygon
extends MultiPoint {
    public static final String TYPE = "Polygon";

    public Polygon(Geometry geometry) {
        super(geometry);
    }

    public static CompositeGeometry toCompositeGeometry(List coordinates) {
        return new Polygon((Geometry)Polygon.buildPolygon(coordinates));
    }

    @Override
    public Map toJsonMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!TYPE.equals(this.getGeometry().getGeometryType())) {
            throw new UnsupportedOperationException("Geometry is not a Polygon");
        }
        map.put("type", TYPE);
        List linearRingsList = this.buildJsonPolygon((com.vividsolutions.jts.geom.Polygon)this.getGeometry());
        map.put("coordinates", linearRingsList);
        return map;
    }

    protected List buildJsonPolygon(com.vividsolutions.jts.geom.Polygon polygon) {
        ArrayList<List<List<Double>>> linearRingsList = new ArrayList<List<List<Double>>>();
        linearRingsList.add(this.buildCoordinatesList(polygon.getExteriorRing().getCoordinates()));
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            linearRingsList.add(this.buildCoordinatesList(polygon.getInteriorRingN(i).getCoordinates()));
        }
        return linearRingsList;
    }

    protected static com.vividsolutions.jts.geom.Polygon buildPolygon(List coordinates) {
        LinearRing exterior = GEOMETRY_FACTORY.createLinearRing(Polygon.getCoordinates((List)coordinates.get(0)));
        LinearRing[] interiorHoles = new LinearRing[coordinates.size() - 1];
        for (int i = 1; i < coordinates.size(); ++i) {
            interiorHoles[i - 1] = GEOMETRY_FACTORY.createLinearRing(Polygon.getCoordinates((List)coordinates.get(i)));
        }
        return GEOMETRY_FACTORY.createPolygon(exterior, interiorHoles);
    }

    @Override
    public List<Position> toGeoRssPositions() {
        if (this.getGeometry().isRectangle()) {
            Envelope envelope = this.getGeometry().getEnvelopeInternal();
            Coordinate upperCorner = new Coordinate(envelope.getMinY(), envelope.getMinX());
            Coordinate lowerCorner = new Coordinate(envelope.getMaxY(), envelope.getMaxX());
            return Arrays.asList(new Box(new Coordinate[]{upperCorner, lowerCorner}));
        }
        Coordinates coords = this.getPolygonCoordinates((com.vividsolutions.jts.geom.Polygon)this.getGeometry());
        return Arrays.asList(new org.apache.abdera.ext.geo.Polygon(coords));
    }

    protected Coordinates getPolygonCoordinates(com.vividsolutions.jts.geom.Polygon polygon) {
        Coordinates coords = new Coordinates();
        for (com.vividsolutions.jts.geom.Coordinate jtsCoordinate : polygon.getExteriorRing().getCoordinates()) {
            coords.add(this.convert(jtsCoordinate));
        }
        return coords;
    }
}

