/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.atom;

import ddf.action.Action;
import ddf.action.ActionProvider;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import net.di2e.ecdr.api.security.SecurityConfiguration;
import net.di2e.ecdr.commons.CDRMetacard;
import net.di2e.ecdr.search.transform.atom.AtomTransformer;
import net.di2e.ecdr.search.transform.atom.AtomTransformerWithContent;
import org.apache.abdera.model.Entry;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomOGCTransformer
extends AtomTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomTransformerWithContent.class);

    public AtomOGCTransformer(ActionProvider viewMetacardProvider, ActionProvider metadataProvider, ActionProvider resourceProvider, ActionProvider thumbnailProvider, MimeType thumbnailMime, MimeType viewMime, List<SecurityConfiguration> securityConfig) {
        super(viewMetacardProvider, metadataProvider, resourceProvider, thumbnailProvider, thumbnailMime, viewMime, securityConfig);
        LOGGER.debug("Created new AtomOGCTransformer for returning metadata with atom entry content element populated");
    }

    @Override
    protected void addLinksToEntry(Entry entry, CDRMetacard metacard, String format, Map<String, Serializable> properties) {
        Action action;
        if (metacard.hasThumbnail() && this.getThumbnailActionProvider() != null && (action = this.getThumbnailActionProvider().getAction((Object)metacard)) != null && action.getUrl() != null) {
            entry.addLink(action.getUrl().toString(), "icon", this.getThumbnailMimeType().getBaseType(), action.getTitle(), null, metacard.getThumbnailLength());
        }
        if (this.getResourceActionProvider() != null && metacard.hasResource()) {
            action = this.getResourceActionProvider().getAction((Object)metacard);
            if (action != null && action.getUrl() != null) {
                entry.addLink(action.getUrl().toString(), "enclosure", metacard.getResourceMIMETypeString(), action.getTitle(), null, metacard.getResourceSizeLong());
            }
        } else if (this.getMetadataActionProvider() != null && (action = this.getMetadataActionProvider().getAction((Object)metacard)) != null && action.getUrl() != null) {
            entry.addLink(action.getUrl().toString(), "enclosure", "text/xml", "View Product", null, -1L);
        }
        if (this.getViewMetacardActionProvider() != null && (action = this.getViewMetacardActionProvider().getAction((Object)metacard)) != null && action.getUrl() != null) {
            String transformFormat = (String)((Object)properties.get("metacard-transformer-name"));
            if (StringUtils.isBlank((String)transformFormat)) {
                transformFormat = StringUtils.defaultIfBlank((String)format, (String)"cdr-atom");
            }
            entry.addLink(action.getUrl().toString() + "?transform=" + transformFormat, "self", "application/atom+xml", "View Atom Entry", null, -1L);
            entry.addLink(action.getUrl().toString(), "alternate", "text/xml", action.getTitle(), null, -1L);
        }
    }
}

