/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.geo.formatter;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.di2e.ecdr.search.transform.geo.formatter.CompositeGeometry;
import org.apache.abdera.ext.geo.Coordinate;
import org.apache.abdera.ext.geo.Position;

public class Point
extends CompositeGeometry {
    private Geometry geometry;
    public static final String TYPE = "Point";

    public Point(Geometry geometry) {
        if (geometry == null) {
            throw new IllegalArgumentException("Geometry argument must not be null");
        }
        if (this.isNotType(geometry)) {
            throw new IllegalArgumentException("Geometry is not a " + this.getClass().getName());
        }
        this.geometry = geometry;
    }

    protected boolean isNotType(Geometry geo) {
        return !this.getClass().getSimpleName().equals(geo.getGeometryType());
    }

    public static CompositeGeometry toCompositeGeometry(List coordinates) {
        return new Point((Geometry)GEOMETRY_FACTORY.createPoint(Point.getCoordinate(coordinates)));
    }

    @Override
    public Map toJsonMap() {
        ArrayList<Double> coordinatesList = new ArrayList<Double>();
        coordinatesList.add(this.geometry.getCoordinate().x);
        coordinatesList.add(this.geometry.getCoordinate().y);
        return this.createMap("coordinates", coordinatesList);
    }

    protected Map createMap(String key, List objects) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", this.getClass().getSimpleName());
        map.put(key, objects);
        return map;
    }

    @Override
    public String toWkt() {
        return this.geometry.toText();
    }

    @Override
    public Geometry getGeometry() {
        return this.geometry;
    }

    @Override
    public List<Position> toGeoRssPositions() {
        return Arrays.asList(new org.apache.abdera.ext.geo.Point(this.convert(this.geometry.getCoordinate())));
    }

    protected Coordinate convert(com.vividsolutions.jts.geom.Coordinate jtsCoordinate) {
        return new Coordinate(jtsCoordinate.y, jtsCoordinate.x);
    }
}

