/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.atom.security.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.di2e.ecdr.api.security.SecurityConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityConfigurationImpl
implements SecurityConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityConfigurationImpl.class);
    private Set<String> formats = Collections.emptySet();
    private String namespace = "urn:us:gov:ic:ism:v2";
    private Map<String, String> attributes = null;

    public void setConfigFormats(List<String> newFormats) {
        LOGGER.debug("ConfigUpdate: Updating the Security formats from {} to {}", this.formats, newFormats);
        this.formats = new HashSet<String>(newFormats);
    }

    public void setNamespace(String newNamespace) {
        LOGGER.debug("ConfigUpdate: Updating the Security namespace from [{}] to [{}]", (Object)this.namespace, (Object)newNamespace);
        this.namespace = newNamespace;
    }

    public void setAttributeList(List<String> attrList) {
        LOGGER.debug("ConfigUpdate: Updating the Security attribute list from {} to {}", this.attributes, attrList);
        this.attributes = new HashMap<String, String>();
        if (attrList != null) {
            for (String attribute : attrList) {
                String[] values = attribute.split("=");
                if (values.length != 2) continue;
                this.attributes.put(values[0], values[1]);
            }
        }
    }

    public Set<String> getFormats() {
        return this.formats;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

