/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.atom.geo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.ext.geo.Box;
import org.apache.abdera.ext.geo.Coordinate;
import org.apache.abdera.ext.geo.Line;
import org.apache.abdera.ext.geo.Multiple;
import org.apache.abdera.ext.geo.Point;
import org.apache.abdera.ext.geo.Polygon;
import org.apache.abdera.ext.geo.Position;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.util.Constants;

public final class GeoHelper {
    public static final String W3C_GEO_NS = "http://www.w3.org/2003/01/geo/wgs84_pos#";
    public static final String SIMPLE_GEO_NS = "http://www.georss.org/georss";
    public static final String GML_NS = "http://www.opengis.net/gml";
    public static final QName QNAME_W3C_POINT = new QName("http://www.w3.org/2003/01/geo/wgs84_pos#", "Point", "geo");
    public static final QName QNAME_W3C_LAT = new QName("http://www.w3.org/2003/01/geo/wgs84_pos#", "lat", "geo");
    public static final QName QNAME_W3C_LONG = new QName("http://www.w3.org/2003/01/geo/wgs84_pos#", "long", "geo");
    public static final QName QNAME_SIMPLE_POINT = new QName("http://www.georss.org/georss", "point", "georss");
    public static final QName QNAME_SIMPLE_LINE = new QName("http://www.georss.org/georss", "line", "georss");
    public static final QName QNAME_SIMPLE_POLYGON = new QName("http://www.georss.org/georss", "polygon", "georss");
    public static final QName QNAME_SIMPLE_BOX = new QName("http://www.georss.org/georss", "box", "georss");
    public static final QName QNAME_WHERE = new QName("http://www.georss.org/georss", "where", "georss");
    public static final QName QNAME_GML_POINT = new QName("http://www.opengis.net/gml", "Point", "gml");
    public static final QName QNAME_GML_POS = new QName("http://www.opengis.net/gml", "pos", "gml");
    public static final QName QNAME_GML_LINESTRING = new QName("http://www.opengis.net/gml", "LineString", "gml");
    public static final QName QNAME_GML_POSLIST = new QName("http://www.opengis.net/gml", "posList", "gml");
    public static final QName QNAME_GML_POLYGON = new QName("http://www.opengis.net/gml", "Polygon", "gml");
    public static final QName QNAME_GML_EXTERIOR = new QName("http://www.opengis.net/gml", "exterior", "gml");
    public static final QName QNAME_GML_LINEARRING = new QName("http://www.opengis.net/gml", "LinearRing", "gml");
    public static final QName QNAME_GML_ENVELOPE = new QName("http://www.opengis.net/gml", "Envelope", "gml");
    public static final QName QNAME_GML_LOWERCORNER = new QName("http://www.opengis.net/gml", "lowerCorner", "gml");
    public static final QName QNAME_GML_UPPERCORNER = new QName("http://www.opengis.net/gml", "upperCorner", "gml");

    private GeoHelper() {
    }

    public static void addPosition(ExtensibleElement element, Position position) {
        GeoHelper.addPosition(element, position, Encoding.SIMPLE);
    }

    public static void addPosition(ExtensibleElement element, Position position, Encoding encoding) {
        switch (encoding) {
            default: {
                break;
            }
            case SIMPLE: {
                GeoHelper.addSimplePosition(element, position);
                break;
            }
            case GML: {
                GeoHelper.addGmlPosition(element, position);
                break;
            }
            case W3C: {
                GeoHelper.addW3CPosition(element, position);
            }
        }
    }

    private static void setPositionAttributes(Element pos, Position position) {
        if (pos != null) {
            if (position.getFeatureTypeTag() != null) {
                pos.setAttributeValue("featuretypetag", position.getFeatureTypeTag());
            }
            if (position.getRelationshipTag() != null) {
                pos.setAttributeValue("relationshiptag", position.getRelationshipTag());
            }
            if (position.getElevation() != null) {
                pos.setAttributeValue("elev", position.getElevation().toString());
            }
            if (position.getFloor() != null) {
                pos.setAttributeValue("floor", position.getFloor().toString());
            }
            if (position.getRadius() != null) {
                pos.setAttributeValue("radius", position.getRadius().toString());
            }
        }
    }

    private static void addGmlPosition(ExtensibleElement element, Position position) {
        ExtensibleElement pos = (ExtensibleElement)element.addExtension(QNAME_WHERE);
        if (position instanceof Point) {
            Point point = (Point)position;
            ExtensibleElement p = (ExtensibleElement)pos.addExtension(QNAME_GML_POINT);
            p.addSimpleExtension(QNAME_GML_POS, point.getCoordinate().toString());
        } else if (position instanceof Line) {
            Multiple m = (Multiple)position;
            ExtensibleElement p = (ExtensibleElement)pos.addExtension(QNAME_GML_LINESTRING);
            p.addSimpleExtension(QNAME_GML_POSLIST, m.getCoordinates().toString());
        } else if (position instanceof Polygon) {
            Multiple m = (Multiple)position;
            ExtensibleElement p = (ExtensibleElement)pos.addExtension(QNAME_GML_POLYGON);
            p = (ExtensibleElement)p.addExtension(QNAME_GML_EXTERIOR);
            p = (ExtensibleElement)p.addExtension(QNAME_GML_LINEARRING);
            p.addSimpleExtension(QNAME_GML_POSLIST, m.getCoordinates().toString());
        } else if (position instanceof Box) {
            Box m = (Box)position;
            ExtensibleElement p = (ExtensibleElement)pos.addExtension(QNAME_GML_ENVELOPE);
            if (m.getLowerCorner() != null) {
                p.addSimpleExtension(QNAME_GML_LOWERCORNER, m.getLowerCorner().toString());
            }
            if (m.getUpperCorner() != null) {
                p.addSimpleExtension(QNAME_GML_UPPERCORNER, m.getUpperCorner().toString());
            }
        }
        GeoHelper.setPositionAttributes((Element)pos, position);
    }

    private static void addSimplePosition(ExtensibleElement element, Position position) {
        Element pos = null;
        if (position instanceof Point) {
            Point point = (Point)position;
            pos = element.addSimpleExtension(QNAME_SIMPLE_POINT, point.getCoordinate().toString());
        } else if (position instanceof Multiple) {
            QName qname;
            Multiple line = (Multiple)position;
            QName qName = position instanceof Line ? QNAME_SIMPLE_LINE : (position instanceof Box ? QNAME_SIMPLE_BOX : (qname = position instanceof Polygon ? QNAME_SIMPLE_POLYGON : null));
            if (qname != null) {
                pos = element.addSimpleExtension(qname, line.getCoordinates().toString());
            }
        }
        GeoHelper.setPositionAttributes(pos, position);
    }

    private static void addW3CPosition(ExtensibleElement element, Position position) {
        if (!(position instanceof Point)) {
            throw new IllegalArgumentException("The W3C Encoding only supports Points");
        }
        Element el = element.getExtension(QNAME_W3C_LAT);
        if (el != null) {
            el.discard();
        }
        if ((el = element.getExtension(QNAME_W3C_LONG)) != null) {
            el.discard();
        }
        Point point = (Point)position;
        ExtensibleElement p = (ExtensibleElement)element.addExtension(QNAME_W3C_POINT);
        p.addSimpleExtension(QNAME_W3C_LAT, Double.toString(point.getCoordinate().getLatitude()));
        p.addSimpleExtension(QNAME_W3C_LONG, Double.toString(point.getCoordinate().getLongitude()));
    }

    private static List<Position> getPositionsList(ExtensibleElement element) {
        ArrayList<Position> list = new ArrayList<Position>();
        GeoHelper.getW3CPosition(element, list);
        GeoHelper.getSimplePosition(element, list);
        GeoHelper.getGMLPosition(element, list);
        return list;
    }

    public static boolean isGeotagged(ExtensibleElement element) {
        if (element.getExtensions(QNAME_SIMPLE_POINT).size() > 0) {
            return true;
        }
        if (element.getExtensions(QNAME_SIMPLE_LINE).size() > 0) {
            return true;
        }
        if (element.getExtensions(QNAME_SIMPLE_BOX).size() > 0) {
            return true;
        }
        if (element.getExtensions(QNAME_SIMPLE_POLYGON).size() > 0) {
            return true;
        }
        if (element.getExtensions(QNAME_WHERE).size() > 0) {
            return true;
        }
        if (element.getExtensions(QNAME_W3C_POINT).size() > 0) {
            return true;
        }
        return element.getExtensions(QNAME_W3C_LAT).size() > 0 && element.getExtensions(QNAME_W3C_LONG).size() > 0;
    }

    public static Iterator<Position> listPositions(ExtensibleElement element) {
        return GeoHelper.getPositionsList(element).iterator();
    }

    public static Position getAsPosition(Element element) {
        Point pos = null;
        QName qname = element.getQName();
        String text = element.getText();
        if (qname.equals(QNAME_GML_POINT)) {
            if ((element = GeoHelper.traverse((ExtensibleElement)element, QNAME_GML_POS)) != null && (text = element.getText()) != null) {
                pos = new Point(text.trim());
            }
        } else if (qname.equals(QNAME_GML_LINESTRING)) {
            if ((element = GeoHelper.traverse((ExtensibleElement)element, QNAME_GML_POSLIST)) != null && (text = element.getText()) != null) {
                pos = new Line(text.trim());
            }
        } else if (qname.equals(QNAME_GML_POLYGON)) {
            if ((element = GeoHelper.traverse((ExtensibleElement)element, QNAME_GML_EXTERIOR, QNAME_GML_LINEARRING, QNAME_GML_POSLIST)) != null && (text = element.getText()) != null) {
                pos = new Polygon(text.trim());
            }
        } else if (qname.equals(QNAME_GML_ENVELOPE)) {
            String lc = ((ExtensibleElement)element).getSimpleExtension(QNAME_GML_LOWERCORNER);
            String uc = ((ExtensibleElement)element).getSimpleExtension(QNAME_GML_UPPERCORNER);
            if (lc != null && uc != null) {
                Coordinate c1 = new Coordinate(lc);
                Coordinate c2 = new Coordinate(uc);
                pos = new Box(new Coordinate[]{c1, c2});
            }
        } else if (qname.equals(QNAME_SIMPLE_POINT) && text != null) {
            pos = new Point(text.trim());
        } else if (qname.equals(QNAME_SIMPLE_LINE) && text != null) {
            pos = new Line(text.trim());
        } else if (qname.equals(QNAME_SIMPLE_BOX) && text != null) {
            pos = new Box(text.trim());
        } else if (qname.equals(QNAME_SIMPLE_POLYGON) && text != null) {
            pos = new Polygon(text.trim());
        } else if (qname.equals(QNAME_W3C_POINT) || qname.equals(Constants.ENTRY)) {
            ArrayList<Position> list = new ArrayList<Position>();
            GeoHelper.getW3CPosition((ExtensibleElement)element, list);
            if (list != null && list.size() > 0) {
                pos = (Position)list.get(0);
            }
        }
        return pos;
    }

    public static Position[] getPositions(ExtensibleElement element) {
        List<Position> positions = GeoHelper.getPositionsList(element);
        return positions.toArray(new Position[positions.size()]);
    }

    private static void getSimplePosition(ExtensibleElement element, List<Position> list) {
        List elements = element.getExtensions(SIMPLE_GEO_NS);
        for (Element el : elements) {
            Position pos = GeoHelper.getAsPosition(el);
            if (pos == null) continue;
            GeoHelper.getPositionAttributes(el, pos);
            list.add(pos);
        }
    }

    private static void getGMLPosition(ExtensibleElement element, List<Position> list) {
        List elements = element.getExtensions(QNAME_WHERE);
        for (ExtensibleElement where : elements) {
            Position pos = null;
            List children = where.getElements();
            for (ExtensibleElement el : children) {
                pos = GeoHelper.getAsPosition((Element)el);
                if (pos == null) continue;
                GeoHelper.getPositionAttributes((Element)el, pos);
                list.add(pos);
            }
        }
    }

    private static ExtensibleElement traverse(ExtensibleElement element, QName ... qnames) {
        QName qname;
        QName[] arr$ = qnames;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (element = (ExtensibleElement)element.getExtension(qname = arr$[i$])) != null; ++i$) {
        }
        return element;
    }

    private static void getPositionAttributes(Element pos, Position position) {
        if (position != null) {
            String featuretypetag = pos.getAttributeValue("featuretypetag");
            String relationshiptag = pos.getAttributeValue("relationshiptag");
            String elevation = pos.getAttributeValue("elev");
            String floor = pos.getAttributeValue("floor");
            String radius = pos.getAttributeValue("radius");
            if (featuretypetag != null) {
                position.setFeatureTypeTag(featuretypetag);
            }
            if (featuretypetag != null) {
                position.setRelationshipTag(relationshiptag);
            }
            if (elevation != null) {
                position.setElevation(Double.valueOf(elevation));
            }
            if (floor != null) {
                position.setFloor(Double.valueOf(floor));
            }
            if (radius != null) {
                position.setRadius(Double.valueOf(radius));
            }
        }
    }

    private static void getW3CPosition(ExtensibleElement element, List<Position> list) {
        GeoHelper.getSimpleW3CPosition(element, list);
        List points = element.getExtensions(QNAME_W3C_POINT);
        for (ExtensibleElement point : points) {
            GeoHelper.getSimpleW3CPosition(point, list);
        }
    }

    private static void getSimpleW3CPosition(ExtensibleElement el, List<Position> list) {
        String slat = el.getSimpleExtension(QNAME_W3C_LAT);
        String slong = el.getSimpleExtension(QNAME_W3C_LONG);
        if (slat != null && slong != null) {
            Point point = new Point(slat.trim() + " " + slong.trim());
            list.add((Position)point);
        }
    }

    public static enum Encoding {
        SIMPLE,
        W3C,
        GML;

    }
}

