/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.geo.formatter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.di2e.ecdr.search.transform.geo.formatter.CompositeGeometry;
import net.di2e.ecdr.search.transform.geo.formatter.Point;
import org.apache.abdera.ext.geo.Position;

public class MultiPoint
extends Point {
    public static final String TYPE = "MultiPoint";

    public MultiPoint(Geometry geometry) {
        super(geometry);
    }

    public static CompositeGeometry toCompositeGeometry(List coordinates) {
        com.vividsolutions.jts.geom.Point[] allPoints = new com.vividsolutions.jts.geom.Point[coordinates.size()];
        for (int i = 0; i < allPoints.length; ++i) {
            allPoints[i] = GEOMETRY_FACTORY.createPoint(MultiPoint.getCoordinate((List)coordinates.get(i)));
        }
        return new MultiPoint((Geometry)GEOMETRY_FACTORY.createMultiPoint(allPoints));
    }

    @Override
    public Map toJsonMap() {
        return this.createMap("coordinates", this.buildCoordinatesList(this.getGeometry().getCoordinates()));
    }

    protected List<List<Double>> buildCoordinatesList(Coordinate[] coordinates) {
        ArrayList<List<Double>> allCoordinatesList = new ArrayList<List<Double>>();
        for (int i = 0; i < coordinates.length; ++i) {
            ArrayList<Double> singleCoordinatesList = new ArrayList<Double>();
            Coordinate coord = coordinates[i];
            singleCoordinatesList.add(coord.x);
            singleCoordinatesList.add(coord.y);
            allCoordinatesList.add(singleCoordinatesList);
        }
        return allCoordinatesList;
    }

    @Override
    public String toWkt() {
        return this.getGeometry().toText();
    }

    @Override
    public List<Position> toGeoRssPositions() {
        ArrayList<Position> list = new ArrayList<Position>();
        for (int i = 0; i < this.getGeometry().getCoordinates().length; ++i) {
            Coordinate jtsCoordinate = this.getGeometry().getCoordinates()[i];
            list.add((Position)new org.apache.abdera.ext.geo.Point(this.convert(jtsCoordinate)));
        }
        return list;
    }
}

