/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.atom;

import ddf.action.ActionProvider;
import ddf.catalog.data.Metacard;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import net.di2e.ecdr.api.security.SecurityConfiguration;
import net.di2e.ecdr.commons.CDRMetacard;
import net.di2e.ecdr.search.transform.atom.AtomTransformer;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Entry;
import org.apache.commons.lang.StringUtils;
import org.codice.ddf.configuration.impl.ConfigurationWatcherImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomTransformerWithContent
extends AtomTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomTransformerWithContent.class);

    public AtomTransformerWithContent(ConfigurationWatcherImpl configWatcher, ActionProvider viewMetacardProvider, ActionProvider metadataProvider, ActionProvider resourceProvider, ActionProvider thumbnailProvider, MimeType thumbnailMime, MimeType viewMime, List<SecurityConfiguration> securityConfig) {
        super(configWatcher, viewMetacardProvider, metadataProvider, resourceProvider, thumbnailProvider, thumbnailMime, viewMime, securityConfig);
        LOGGER.debug("Created new AtomTransformerWithContent for returning metadata with atom entry content element populated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntryElements(Entry entry, CDRMetacard metacard, Map<String, Serializable> properties) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(AtomTransformerWithContent.class.getClassLoader());
            String metadata = metacard.getMetadata();
            if (StringUtils.isNotEmpty((String)metadata)) {
                entry.setContent(metadata, Content.Type.XML);
                LOGGER.trace("Setting the Atom Entry content element to the metadata of the Metacard");
            }
            this.setEntrySecurity(entry, (Metacard)metacard);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }
}

