/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.atom.security.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.di2e.ecdr.search.transform.atom.security.SecurityConfiguration;
import org.apache.commons.lang.StringUtils;

public class SecurityConfigurationImpl
implements SecurityConfiguration {
    private Set<String> formats = Collections.emptySet();
    private String namespace = "urn:us:gov:ic:ism:v2";
    private Map<String, String> attributes = null;

    public void setConfigFormats(String newFormats) {
        if (StringUtils.isNotBlank((String)newFormats)) {
            this.formats = new HashSet<String>(Arrays.asList(newFormats.split(",")));
        }
    }

    public void setNamespace(String newNamespace) {
        this.namespace = newNamespace;
    }

    public void setAttributeList(String newAttributes) {
        if (newAttributes != null) {
            List<String> attrList = Arrays.asList(newAttributes.split(","));
            this.setAttributesList(attrList);
        }
    }

    public void setAttributesList(List<String> attrList) {
        this.attributes = new HashMap<String, String>();
        if (attrList != null) {
            for (String attribute : attrList) {
                String[] values = attribute.split("=");
                if (values.length != 2) continue;
                this.attributes.put(values[0], values[1]);
            }
        }
    }

    @Override
    public Set<String> getFormats() {
        return this.formats;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

