/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.atom.security.impl;

import ddf.catalog.data.Attribute;
import ddf.catalog.data.Metacard;
import java.io.Serializable;
import java.util.Map;
import net.di2e.ecdr.commons.CDRMetacard;
import net.di2e.ecdr.search.transform.atom.security.SecurityData;
import net.di2e.ecdr.search.transform.atom.security.SecurityMarkingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetacardSecurityMarkingHandler
implements SecurityMarkingHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetacardSecurityMarkingHandler.class);

    @Override
    public SecurityData getSecurityData(Metacard metacard) {
        Map security;
        Attribute attribute = metacard.getAttribute("security-namespace");
        String namespace = null;
        if (attribute != null) {
            Serializable value = attribute.getValue();
            if (value instanceof String) {
                namespace = (String)((Object)value);
            } else {
                LOGGER.debug("The Metacard Attribute named [{}], was not a String, instead it was [{}]", (Object)"security-namespace", value.getClass());
            }
        }
        if ((security = new CDRMetacard(metacard).getSecurity()) != null && !security.isEmpty()) {
            return new SecurityData(security, namespace);
        }
        return null;
    }
}

