/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.atom.security.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import net.di2e.ecdr.commons.util.ConfigAdminUtils;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtomFeedConfig {
    private static final String CONFIG_PID = "cdr-security-configurations";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAtomFeedConfig.class);
    private ConfigurationAdmin configAdmin;
    private List<Configuration> configurationList = new ArrayList<Configuration>();

    public DefaultAtomFeedConfig(ConfigurationAdmin configurationAdmin) {
        this.configAdmin = configurationAdmin;
    }

    public void init() throws IOException, InvalidSyntaxException {
        if (!ConfigAdminUtils.configurationPidExists((ConfigurationAdmin)this.configAdmin, (String)CONFIG_PID)) {
            for (DefaultConfig config : DefaultConfig.values()) {
                LOGGER.debug("Adding configuration with format {}", (Object)config.getFormats());
                Configuration configuration = this.configAdmin.createFactoryConfiguration(CONFIG_PID);
                Hashtable<String, String> properties = new Hashtable<String, String>();
                ((Dictionary)properties).put("configFormats", config.getFormats());
                ((Dictionary)properties).put("namespace", config.getNamespace());
                ((Dictionary)properties).put("attributeList", config.getAttributes());
                configuration.update(properties);
                this.configurationList.add(configuration);
            }
        }
    }

    public static enum DefaultConfig {
        ISM_v9("atom,atom-ddms,atom-ddms-4.1,query-default,metacard-default,default", "urn:us:gov:ic:ism", "DESVersion=9,classification=U,ownerProducer=USA"),
        ISM_v2("atom-ddms-2.0", "urn:us:gov:ic:ism:v2", "classification=U,ownerProducer=USA");

        private final String format;
        private final String namespace;
        private final String attributes;

        private DefaultConfig(String entryFormat, String entryNamespace, String entryAttributes) {
            this.format = entryFormat;
            this.namespace = entryNamespace;
            this.attributes = entryAttributes;
        }

        public String getFormats() {
            return this.format;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getAttributes() {
            return this.attributes;
        }
    }
}

