/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.atom;

import ddf.action.ActionProvider;
import ddf.catalog.data.BinaryContent;
import ddf.catalog.data.Metacard;
import ddf.catalog.transform.CatalogTransformerException;
import ddf.catalog.transform.MetacardTransformer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import net.di2e.ecdr.commons.CDRMetacard;
import net.di2e.ecdr.search.transform.atom.AtomTransformer;
import net.di2e.ecdr.search.transform.atom.security.SecurityConfiguration;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Entry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codice.ddf.configuration.impl.ConfigurationWatcherImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomTransformerWithPayload
extends AtomTransformer {
    private static final String TRANSFORMER_ID = "atom-with-payload";
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomTransformerWithPayload.class);
    private Map<String, MetacardTransformer> metacardTransformerMap = new HashMap<String, MetacardTransformer>();

    public AtomTransformerWithPayload(ConfigurationWatcherImpl configWatcher, ActionProvider viewMetacardProvider, ActionProvider metadataProvider, ActionProvider resourceProvider, ActionProvider thumbnailProvider, MimeType thumbnailMime, MimeType viewMime, List<SecurityConfiguration> securityConfig) {
        super(configWatcher, viewMetacardProvider, metadataProvider, resourceProvider, thumbnailProvider, thumbnailMime, viewMime, securityConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntryElements(Entry entry, CDRMetacard metacard, Map<String, Serializable> properties) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(AtomTransformerWithPayload.class.getClassLoader());
            String metadata = this.getMetadataXML((Metacard)metacard, (String)((Object)properties.get("metacard-transformer-name")));
            entry.addExtension(Abdera.getNewParser().parse((Reader)new StringReader(metadata)).getRoot());
            CDRMetacard newMetacard = new CDRMetacard((Metacard)metacard);
            newMetacard.setMetadata(metadata);
            super.setEntrySecurity(entry, (Metacard)newMetacard);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    protected String getMetadataXML(Metacard metacard, String format) {
        String metadata;
        block18: {
            MetacardTransformer metacardTransformer;
            metadata = null;
            LOGGER.debug("Getting metadata to include in atom response in the format [{}]", (Object)format);
            if (StringUtils.isNotBlank((String)format) && (metacardTransformer = this.metacardTransformerMap.get(format)) != null) {
                try {
                    LOGGER.debug("Calling the MetacardTransformer with id [{}] to transform the Metacard into XML Metadata", (Object)format);
                    BinaryContent binaryContent = metacardTransformer.transform(metacard, null);
                    String mimeValue = binaryContent.getMimeTypeValue();
                    if (!StringUtils.isNotBlank((String)mimeValue) || !mimeValue.contains("xml")) break block18;
                    try (InputStream inputStream = binaryContent.getInputStream();){
                        metadata = IOUtils.toString((InputStream)inputStream);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Error while writing transformed Metacard into a String: " + e.getMessage(), (Throwable)e);
                    }
                }
                catch (CatalogTransformerException e) {
                    LOGGER.warn("Error while transforming metacard using the [{}] MetacardTransformer", (Object)format);
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (metadata == null) {
            LOGGER.debug("A MetacardTransform didn't exist for format [{}] or ran into problems when transforming Metacard, so falling back to using the Metadata in the Metacard", (Object)format);
            metadata = metacard.getMetadata();
        }
        return metadata;
    }

    public void metacardTransformerAdded(MetacardTransformer transformer, Map<String, Object> map) {
        String id = (String)map.get("id");
        if (!StringUtils.equalsIgnoreCase((String)id, (String)TRANSFORMER_ID)) {
            this.metacardTransformerMap.put(id, transformer);
            LOGGER.debug("Adding MetacardTransformer with id [{}] to transformer map.", (Object)id);
        }
    }

    public void metacardTransformerRemoved(MetacardTransformer transformer, Map<String, Object> map) {
        String id = (String)map.get("id");
        this.metacardTransformerMap.remove(id);
        LOGGER.debug("Removing MetacardTransformer with id [{}] from transformer map.", (Object)id);
    }
}

