/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.geo.formatter;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.di2e.ecdr.search.transform.geo.formatter.CompositeGeometry;
import net.di2e.ecdr.search.transform.geo.formatter.Polygon;
import org.apache.abdera.ext.geo.Position;

public class MultiPolygon
extends Polygon {
    public static final String TYPE = "MultiPolygon";

    public MultiPolygon(Geometry geometry) {
        super(geometry);
    }

    public static CompositeGeometry toCompositeGeometry(List coordinates) {
        com.vividsolutions.jts.geom.Polygon[] allPolygons = new com.vividsolutions.jts.geom.Polygon[coordinates.size()];
        for (int i = 0; i < allPolygons.length; ++i) {
            allPolygons[i] = MultiPolygon.buildPolygon((List)coordinates.get(i));
        }
        return new MultiPolygon((Geometry)GEOMETRY_FACTORY.createMultiPolygon(allPolygons));
    }

    @Override
    public Map toJsonMap() {
        ArrayList<List> listOfPolygons;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (TYPE.equals(this.getGeometry().getGeometryType())) {
            map.put("type", TYPE);
            listOfPolygons = new ArrayList<List>();
            for (int i = 0; i < this.getGeometry().getNumGeometries(); ++i) {
                List polygon = this.buildJsonPolygon((com.vividsolutions.jts.geom.Polygon)this.getGeometry().getGeometryN(i));
                listOfPolygons.add(polygon);
            }
        } else {
            throw new UnsupportedOperationException("Geometry is not a MultiPolygon");
        }
        map.put("coordinates", listOfPolygons);
        return map;
    }

    @Override
    public List<Position> toGeoRssPositions() {
        ArrayList<Position> positions = new ArrayList<Position>();
        for (int i = 0; i < this.getGeometry().getNumGeometries(); ++i) {
            CompositeGeometry compositeGeo = CompositeGeometry.getCompositeGeometry(this.getGeometry().getGeometryN(i));
            positions.addAll(compositeGeo.toGeoRssPositions());
        }
        return positions;
    }
}

