/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.geo.formatter;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.di2e.ecdr.search.transform.geo.formatter.CompositeGeometry;
import net.di2e.ecdr.search.transform.geo.formatter.MultiPolygon;
import org.apache.abdera.ext.geo.Position;

public class GeometryCollection
extends MultiPolygon {
    public static final String TYPE = "GeometryCollection";

    public GeometryCollection(Geometry geometry) {
        super(geometry);
    }

    public static CompositeGeometry toCompositeGeometry(List geometries) {
        Geometry[] allGeometries = new Geometry[geometries.size()];
        for (int i = 0; i < allGeometries.length; ++i) {
            Map jsonGeometry = (Map)geometries.get(i);
            allGeometries[i] = GeometryCollection.getCompositeGeometry(jsonGeometry.get("type").toString(), jsonGeometry).getGeometry();
        }
        return new GeometryCollection((Geometry)GEOMETRY_FACTORY.createGeometryCollection(allGeometries));
    }

    @Override
    public Map toJsonMap() {
        ArrayList<Map> listOfGeometries;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (TYPE.equals(this.getGeometry().getGeometryType())) {
            map.put("type", TYPE);
            listOfGeometries = new ArrayList<Map>();
            for (int i = 0; i < this.getGeometry().getNumGeometries(); ++i) {
                listOfGeometries.add(GeometryCollection.getCompositeGeometry(this.getGeometry().getGeometryN(i)).toJsonMap());
            }
        } else {
            throw new UnsupportedOperationException("Geometry is not a GeometryCollection");
        }
        map.put("geometries", listOfGeometries);
        return map;
    }

    @Override
    public List<Position> toGeoRssPositions() {
        ArrayList<Position> positions = new ArrayList<Position>();
        for (int i = 0; i < this.getGeometry().getNumGeometries(); ++i) {
            CompositeGeometry compositeGeo = CompositeGeometry.getCompositeGeometry(this.getGeometry().getGeometryN(i));
            positions.addAll(compositeGeo.toGeoRssPositions());
        }
        return positions;
    }
}

