/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.geo.formatter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.List;
import java.util.Map;
import net.di2e.ecdr.search.transform.geo.formatter.GeometryCollection;
import net.di2e.ecdr.search.transform.geo.formatter.LineString;
import net.di2e.ecdr.search.transform.geo.formatter.MultiLineString;
import net.di2e.ecdr.search.transform.geo.formatter.MultiPoint;
import net.di2e.ecdr.search.transform.geo.formatter.MultiPolygon;
import net.di2e.ecdr.search.transform.geo.formatter.Point;
import net.di2e.ecdr.search.transform.geo.formatter.Polygon;
import org.apache.abdera.ext.geo.Position;

public abstract class CompositeGeometry {
    public static final String TYPE_KEY = "type";
    public static final String COORDINATES_KEY = "coordinates";
    public static final String PROPERTIES_KEY = "properties";
    public static final String GEOMETRY_KEY = "geometry";
    public static final String GEOMETRIES_KEY = "geometries";
    protected static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    public abstract Map toJsonMap();

    public abstract String toWkt();

    public abstract List<Position> toGeoRssPositions();

    public abstract Geometry getGeometry();

    public static CompositeGeometry getCompositeGeometry(Geometry geometry) {
        if (geometry != null) {
            if ("Point".equals(geometry.getGeometryType())) {
                return new Point(geometry);
            }
            if ("LineString".equals(geometry.getGeometryType())) {
                return new LineString(geometry);
            }
            if ("MultiPoint".equals(geometry.getGeometryType())) {
                return new MultiPoint(geometry);
            }
            if ("MultiLineString".equals(geometry.getGeometryType())) {
                return new MultiLineString(geometry);
            }
            if ("Polygon".equals(geometry.getGeometryType())) {
                return new Polygon(geometry);
            }
            if ("MultiPolygon".equals(geometry.getGeometryType())) {
                return new MultiPolygon(geometry);
            }
            if ("GeometryCollection".equals(geometry.getGeometryType())) {
                return new GeometryCollection(geometry);
            }
        }
        return null;
    }

    public static CompositeGeometry getCompositeGeometry(String type, Map jsonObject) {
        if (type != null) {
            if ("GeometryCollection".equals(type)) {
                List geometries = (List)jsonObject.get(GEOMETRIES_KEY);
                return GeometryCollection.toCompositeGeometry(geometries);
            }
            List coordinates = (List)jsonObject.get(COORDINATES_KEY);
            if ("Point".equals(type)) {
                return Point.toCompositeGeometry(coordinates);
            }
            if ("LineString".equals(type)) {
                return LineString.toCompositeGeometry(coordinates);
            }
            if ("MultiPoint".equals(type)) {
                return MultiPoint.toCompositeGeometry(coordinates);
            }
            if ("MultiLineString".equals(type)) {
                return MultiLineString.toCompositeGeometry(coordinates);
            }
            if ("Polygon".equals(type)) {
                return Polygon.toCompositeGeometry(coordinates);
            }
            if ("MultiPolygon".equals(type)) {
                return MultiPolygon.toCompositeGeometry(coordinates);
            }
        }
        return null;
    }

    protected static Coordinate getCoordinate(List primitiveCoordinates) {
        if (primitiveCoordinates != null && !primitiveCoordinates.isEmpty()) {
            double x = CompositeGeometry.getDouble(primitiveCoordinates.get(0));
            double y = CompositeGeometry.getDouble(primitiveCoordinates.get(1));
            return new Coordinate(x, y);
        }
        return new Coordinate();
    }

    private static double getDouble(Object object) {
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object != null) {
            return Double.valueOf(object.toString());
        }
        return 0.0;
    }

    protected static Coordinate[] getCoordinates(List<List<String>> primitiveCoordinatesList) {
        if (primitiveCoordinatesList != null && !primitiveCoordinatesList.isEmpty()) {
            Coordinate[] coordinatesArray = new Coordinate[primitiveCoordinatesList.size()];
            for (int i = 0; i < coordinatesArray.length; ++i) {
                coordinatesArray[i] = CompositeGeometry.getCoordinate(primitiveCoordinatesList.get(i));
            }
            return coordinatesArray;
        }
        return new Coordinate[0];
    }
}

