/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.atom.response.security;

import ddf.catalog.data.Metacard;
import ddf.catalog.data.impl.MetacardImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import net.di2e.ecdr.search.transform.atom.security.SecurityData;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.commons.lang.StringUtils;

public final class SecurityMarkingParser {
    private static final Set<String> NAMESPACES = new HashSet<String>();

    private SecurityMarkingParser() {
    }

    public static Metacard addSecurityToMetacard(Metacard metacard, Entry entry) {
        HashMap<String, List<String>> securityProps = new HashMap<String, List<String>>();
        MetacardImpl metacardImpl = new MetacardImpl(metacard);
        List attributes = entry.getAttributes();
        if (attributes != null) {
            String metacardSecurityNamespace = null;
            for (QName qName : attributes) {
                String value;
                String namespace = qName.getNamespaceURI();
                if (!NAMESPACES.contains(namespace) || !StringUtils.isNotBlank((String)(value = entry.getAttributeValue(qName)))) continue;
                securityProps.put(qName.getLocalPart(), SecurityMarkingParser.getValues(value));
                if (metacardSecurityNamespace != null) continue;
                metacardSecurityNamespace = namespace;
            }
            if (!securityProps.isEmpty()) {
                metacardImpl.setSecurity(securityProps);
                metacardImpl.setAttribute("security-namespace", metacardSecurityNamespace);
            }
        }
        return metacardImpl;
    }

    public static SecurityData getFeedSecurityMarkings(Feed feed) {
        List attributes = feed.getAttributes();
        if (attributes != null) {
            HashMap<String, List<String>> securityProps = new HashMap<String, List<String>>();
            String feedNamespace = null;
            for (QName qName : attributes) {
                String value;
                String namespace = qName.getNamespaceURI();
                if (!NAMESPACES.contains(namespace) || !StringUtils.isNotBlank((String)(value = feed.getAttributeValue(qName)))) continue;
                securityProps.put(qName.getLocalPart(), SecurityMarkingParser.getValues(value));
                if (feedNamespace != null) continue;
                feedNamespace = namespace;
            }
            if (!securityProps.isEmpty()) {
                return new SecurityData(securityProps, feedNamespace);
            }
        }
        return null;
    }

    public static List<String> getValues(String attributeValue) {
        String[] values = attributeValue.split(" ");
        return Arrays.asList(values);
    }

    static {
        NAMESPACES.add("urn:us:gov:ic:ism:v2");
        NAMESPACES.add("urn:us:gov:ic:ism");
    }
}

